/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.spell.properties;

import com.binaris.wizardry.api.content.spell.properties.IPropertyType;
import com.binaris.wizardry.api.content.spell.properties.SpellProperty;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.nbt.CompoundTag;

public class PropertyType<T>
implements IPropertyType<T> {
    private final BiFunction<JsonElement, String, SpellProperty<T>> jsonDeserializer;
    private final BiFunction<CompoundTag, String, SpellProperty<T>> tagDeserializer;
    private final BiConsumer<JsonObject, SpellProperty<T>> jsonSerializer;
    private final BiConsumer<CompoundTag, SpellProperty<T>> tagSerializer;

    public PropertyType(BiFunction<JsonElement, String, SpellProperty<T>> jsonDeserializer, BiFunction<CompoundTag, String, SpellProperty<T>> tagDeserializer, BiConsumer<JsonObject, SpellProperty<T>> jsonSerializer, BiConsumer<CompoundTag, SpellProperty<T>> tagSerializer) {
        this.jsonDeserializer = jsonDeserializer;
        this.tagDeserializer = tagDeserializer;
        this.jsonSerializer = jsonSerializer;
        this.tagSerializer = tagSerializer;
    }

    @Override
    public SpellProperty<T> deserialize(JsonElement json, String loc) {
        return this.jsonDeserializer.apply(json, loc);
    }

    @Override
    public SpellProperty<T> deserialize(CompoundTag tag, String loc) {
        return this.tagDeserializer.apply(tag, loc);
    }

    @Override
    public void serialize(JsonObject json, SpellProperty<T> prop) {
        this.jsonSerializer.accept(json, prop);
    }

    @Override
    public void serialize(CompoundTag tag, SpellProperty<T> prop) {
        this.tagSerializer.accept(tag, prop);
    }
}

