/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.spell.properties;

import com.binaris.wizardry.api.content.event.EBPlayerJoinServerEvent;
import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellContext;
import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.properties.SpellProperty;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.core.networking.s2c.SpellPropertiesSyncS2C;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class SpellProperties {
    private final List<SpellProperty<?>> properties;

    private SpellProperties(List<SpellProperty<?>> properties) {
        this.properties = properties;
    }

    public static SpellProperties empty() {
        return new SpellProperties(new ArrayList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SpellProperties fromNbt(CompoundTag tag) {
        Builder builder = SpellProperties.builder();
        for (String key : tag.m_128431_()) {
            SpellProperty<?> temp;
            if (key.equals("base_properties") || (temp = SpellProperty.fromID(key)) == null || temp.type == null) continue;
            builder.add(temp.type.deserialize(tag, key));
        }
        if (tag.m_128441_("base_properties")) {
            CompoundTag basePropsTag = tag.m_128469_("base_properties");
            for (String key : basePropsTag.m_128431_()) {
                SpellProperty<?> temp = SpellProperty.fromID(key);
                if (temp == null || temp.type == null) continue;
                builder.add(temp.type.deserialize(basePropsTag, key));
            }
        }
        return builder.build();
    }

    public static SpellProperties fromJson(JsonObject jsonObject) {
        Builder builder = SpellProperties.builder();
        jsonObject.entrySet().forEach(entry -> {
            String id = (String)entry.getKey();
            if (id.equals("base_properties")) {
                return;
            }
            SpellProperty<?> temp = SpellProperty.fromID(id);
            if (temp == null || temp.type == null) {
                return;
            }
            builder.add(temp.type.deserialize((JsonElement)entry.getValue(), id));
        });
        if (jsonObject.has("base_properties")) {
            JsonObject basePropsJson = jsonObject.getAsJsonObject("base_properties");
            basePropsJson.entrySet().forEach(entry -> {
                String id = (String)entry.getKey();
                SpellProperty<?> temp = SpellProperty.fromID(id);
                if (temp == null || temp.type == null) {
                    return;
                }
                builder.add(temp.type.deserialize((JsonElement)entry.getValue(), id));
            });
        }
        return builder.build();
    }

    public static void onPlayerJoin(EBPlayerJoinServerEvent event) {
        if (event.getPlayer().m_9236_().f_46443_) {
            return;
        }
        Map<ResourceLocation, SpellProperties> map = Services.REGISTRY_UTIL.getSpells().stream().collect(Collectors.toMap(Spell::getLocation, Spell::getProperties));
        Services.NETWORK_HELPER.sendTo((ServerPlayer)event.getPlayer(), new SpellPropertiesSyncS2C(map));
    }

    public <T> T get(SpellProperty<T> property) {
        for (SpellProperty<?> prop : this.properties) {
            if (!prop.equals(property)) continue;
            return (T)prop.get();
        }
        return property.getDefaultValue();
    }

    public List<SpellProperty<?>> getProperties() {
        return this.properties;
    }

    public int getCooldown() {
        return this.get(DefaultProperties.COOLDOWN);
    }

    public int getCost() {
        return this.get(DefaultProperties.COST);
    }

    public int getChargeup() {
        return this.get(DefaultProperties.CHARGEUP);
    }

    public SpellType getType() {
        String type = this.get(DefaultProperties.SPELL_TYPE);
        return SpellType.fromName(type);
    }

    public SpellTier getTier() {
        String s = this.get(DefaultProperties.TIER);
        for (SpellTier tier : Services.REGISTRY_UTIL.getTiers()) {
            if (!tier.getOrCreateLocation().toString().equals(s)) continue;
            return tier;
        }
        return SpellTiers.NOVICE;
    }

    public Element getElement() {
        String s = this.get(DefaultProperties.ELEMENT);
        for (Element element : Services.REGISTRY_UTIL.getElements()) {
            if (!element.getLocation().toString().equals(s)) continue;
            return element;
        }
        return Elements.MAGIC;
    }

    public SpellAction getAction() {
        String action = this.get(DefaultProperties.SPELL_ACTION);
        SpellAction spellAction = SpellAction.get(ResourceLocation.m_135820_((String)action));
        return spellAction != null ? spellAction : SpellAction.NONE;
    }

    public boolean isEnabledInContext(SpellContext context) {
        Map<String, Boolean> enabled = this.get(DefaultProperties.ENABLED);
        return enabled.getOrDefault(context.getKey(), true);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        JsonObject baseProps = new JsonObject();
        this.addProperty(json, DefaultProperties.ENABLED);
        this.addProperty(json, DefaultProperties.TIER);
        this.addProperty(json, DefaultProperties.ELEMENT);
        this.addProperty(json, DefaultProperties.SPELL_TYPE);
        this.addProperty(json, DefaultProperties.COST);
        this.addProperty(json, DefaultProperties.COOLDOWN);
        this.addProperty(json, DefaultProperties.CHARGEUP);
        this.addProperty(json, DefaultProperties.SPELL_ACTION);
        this.properties.stream().filter(p -> !this.isBaseProperty((SpellProperty<?>)p)).forEach(p -> this.addProperty(baseProps, (SpellProperty)p));
        if (baseProps.size() > 0) {
            json.add("base_properties", (JsonElement)baseProps);
        }
        return json;
    }

    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        CompoundTag baseProps = new CompoundTag();
        this.addProperty(tag, DefaultProperties.ENABLED);
        this.addProperty(tag, DefaultProperties.TIER);
        this.addProperty(tag, DefaultProperties.ELEMENT);
        this.addProperty(tag, DefaultProperties.SPELL_TYPE);
        this.addProperty(tag, DefaultProperties.COST);
        this.addProperty(tag, DefaultProperties.COOLDOWN);
        this.addProperty(tag, DefaultProperties.CHARGEUP);
        this.addProperty(tag, DefaultProperties.SPELL_ACTION);
        this.properties.stream().filter(p -> !this.isBaseProperty((SpellProperty<?>)p)).forEach(p -> this.addProperty(baseProps, (SpellProperty)p));
        if (!baseProps.m_128456_()) {
            tag.m_128365_("base_properties", (Tag)baseProps);
        }
        return tag;
    }

    private <T> void addProperty(CompoundTag parent, SpellProperty<T> referenceProperty) {
        SpellProperty property = this.getProperties().stream().filter(p -> p.equals(referenceProperty)).map(p -> p).findFirst().orElse(null);
        if (property == null) {
            return;
        }
        property.type.serialize(parent, property);
    }

    private <T> void addProperty(JsonObject parent, SpellProperty<T> referenceProperty) {
        SpellProperty property = this.getProperties().stream().filter(p -> p.equals(referenceProperty)).map(p -> p).findFirst().orElse(null);
        if (property == null) {
            return;
        }
        property.type.serialize(parent, property);
    }

    private boolean isBaseProperty(@NotNull SpellProperty<?> prop) {
        return prop.identifier.equals(DefaultProperties.ENABLED.identifier) || prop.identifier.equals(DefaultProperties.TIER.identifier) || prop.identifier.equals(DefaultProperties.ELEMENT.identifier) || prop.identifier.equals(DefaultProperties.SPELL_TYPE.identifier) || prop.identifier.equals(DefaultProperties.COST.identifier) || prop.identifier.equals(DefaultProperties.COOLDOWN.identifier) || prop.identifier.equals(DefaultProperties.CHARGEUP.identifier) || prop.identifier.equals(DefaultProperties.SPELL_ACTION.identifier);
    }

    public static class Builder {
        private final List<SpellProperty<?>> builder = new ArrayList();

        private Builder() {
        }

        public Builder assignBaseProperties(SpellTier tier, Element element, SpellType type, SpellAction action, int cost, int charge, int cooldown) {
            this.add(DefaultProperties.ENABLED);
            this.add(DefaultProperties.ELEMENT, element.getLocation().toString());
            this.add(DefaultProperties.SPELL_TYPE, type.getUnlocalisedName());
            this.add(DefaultProperties.TIER, tier.getOrCreateLocation().toString());
            this.add(DefaultProperties.SPELL_ACTION, action.location.toString());
            this.add(DefaultProperties.COST, cost);
            this.add(DefaultProperties.COOLDOWN, cooldown);
            this.add(DefaultProperties.CHARGEUP, charge);
            return this;
        }

        public <T> Builder add(SpellProperty<T> property) {
            if (property != null) {
                SpellProperty<T> cloned = property.copyOf();
                this.builder.add(cloned);
            }
            return this;
        }

        public <T> Builder add(SpellProperty<T> property, T defaultValue) {
            if (property != null) {
                SpellProperty<T> cloned = property.copyOf();
                cloned.defaultValue(defaultValue);
                this.builder.add(cloned);
            }
            return this;
        }

        public SpellProperties build() {
            return new SpellProperties(new ArrayList(this.builder));
        }
    }
}

