/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.util;

import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.GeometryUtil;
import com.binaris.wizardry.core.platform.Services;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class BlockUtil {
    public static boolean canBlockBeReplaced(Level world, BlockPos pos) {
        return BlockUtil.canBlockBeReplaced(world, pos, false);
    }

    public static Integer getNearestFloor(Level world, BlockPos pos, int range) {
        return BlockUtil.getNearestSurface(world, pos, Direction.UP, range, true, SurfaceCriteria.COLLIDABLE);
    }

    public static boolean canBlockBeReplaced(Level world, BlockPos pos, boolean excludeLiquids) {
        return !(!world.m_46859_(new BlockPos((Vec3i)pos)) && !world.m_8055_(pos).m_247087_() || excludeLiquids && world.m_8055_(pos).m_278721_());
    }

    public static boolean canBreak(Player player, Level level, BlockPos pos, boolean powerful) {
        if (level.f_46443_) {
            EBLogger.error("BlockUtils#canBreak called from the client side! Blocks should be modified server-side only", new Object[0]);
            return true;
        }
        if (Services.PLATFORM.firePlayerBlockBreakEvent(level, pos, player)) {
            return false;
        }
        if (player.m_7500_()) {
            return true;
        }
        if (!player.m_36326_()) {
            return false;
        }
        if (level.m_151570_(pos)) {
            return false;
        }
        BlockState state = level.m_8055_(pos);
        if (state.m_60800_((BlockGetter)level, pos) < 0.0f) {
            return false;
        }
        if (player.m_5833_()) {
            return false;
        }
        if (state.m_60800_((BlockGetter)level, pos) > 3.0f && !powerful) {
            return false;
        }
        return level.m_7966_(player, pos);
    }

    public static boolean canBreak(Mob mob, Level level, BlockPos pos) {
        if (level.f_46443_) {
            EBLogger.error("BlockUtils#canBreak called from the client side! Blocks should be modified server-side only", new Object[0]);
            return true;
        }
        if (Services.PLATFORM.fireMobBlockBreakEvent(level, pos, mob)) {
            return false;
        }
        if (level.m_151570_(pos)) {
            return false;
        }
        BlockState state = level.m_8055_(pos);
        if (state.m_60800_((BlockGetter)level, pos) < 0.0f) {
            return false;
        }
        return !(state.m_60800_((BlockGetter)level, pos) > 3.0f);
    }

    public static Direction[] getHorizontals() {
        return (Direction[])Arrays.stream(Direction.values()).filter(direction -> direction.m_122434_().m_122479_()).sorted(Comparator.comparingInt(Direction::m_122416_)).toArray(Direction[]::new);
    }

    public static boolean canPlaceBlock(LivingEntity placer, Level world, BlockPos pos) {
        if (world.f_46443_) {
            EBLogger.error("BlockUtils#canPlaceBlock called from the client side! Blocks should be modified server-side only", new Object[0]);
            return true;
        }
        if (!EntityUtil.canDamageBlocks(placer, world)) {
            return false;
        }
        if (world.m_151570_(pos)) {
            return false;
        }
        return !(placer instanceof Player) || world.m_7966_((Player)placer, pos);
    }

    @Nullable
    public static BlockPos findNearbyFloorSpace(Entity entity, int horizontalRange, int verticalRange) {
        Level world = entity.m_9236_();
        BlockPos origin = entity.m_20183_();
        return BlockUtil.findNearbyFloorSpace(world, origin, horizontalRange, verticalRange, true, entity);
    }

    @Nullable
    public static BlockPos findNearbyFloorSpace(Level world, BlockPos origin, int horizontalRange, int verticalRange, boolean lineOfSight, Entity entity) {
        ArrayList<BlockPos> possibleLocations = new ArrayList<BlockPos>();
        Vec3 centre = GeometryUtil.getCentre(origin);
        for (int x = -horizontalRange; x <= horizontalRange; ++x) {
            for (int z = -horizontalRange; z <= horizontalRange; ++z) {
                BlockHitResult rayTrace;
                Integer y = BlockUtil.getNearestFloor(world, origin.m_7918_(x, 0, z), verticalRange);
                if (y == null) continue;
                BlockPos location = new BlockPos(origin.m_123341_() + x, y.intValue(), origin.m_123343_() + z);
                if (lineOfSight && (rayTrace = world.m_45547_(new ClipContext(centre, GeometryUtil.getCentre(location), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, entity))).m_6662_() == HitResult.Type.BLOCK) continue;
                possibleLocations.add(location);
            }
        }
        if (possibleLocations.isEmpty()) {
            return null;
        }
        return (BlockPos)possibleLocations.get(world.f_46441_.m_188503_(possibleLocations.size()));
    }

    @Nullable
    public static BlockPos findNearbyFloorSpace(Level world, BlockPos origin, int horizontalRange, int verticalRange, boolean lineOfSight) {
        ArrayList<BlockPos> possibleLocations = new ArrayList<BlockPos>();
        Vec3 centre = GeometryUtil.getCentre(origin);
        for (int x = -horizontalRange; x <= horizontalRange; ++x) {
            for (int z = -horizontalRange; z <= horizontalRange; ++z) {
                BlockHitResult rayTrace;
                Integer y = BlockUtil.getNearestFloor(world, origin.m_7918_(x, 0, z), verticalRange);
                if (y == null) continue;
                BlockPos location = new BlockPos(origin.m_123341_() + x, y.intValue(), origin.m_123343_() + z);
                if (lineOfSight && (rayTrace = world.m_45547_(new ClipContext(centre, GeometryUtil.getCentre(location), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, null))).m_6662_() == HitResult.Type.BLOCK) continue;
                possibleLocations.add(location);
            }
        }
        if (possibleLocations.isEmpty()) {
            return null;
        }
        return (BlockPos)possibleLocations.get(world.f_46441_.m_188503_(possibleLocations.size()));
    }

    public static boolean isBlockUnbreakable(Level world, BlockPos pos) {
        return !world.m_46859_(new BlockPos((Vec3i)pos)) && world.m_8055_(pos).m_280296_();
    }

    public static List<BlockPos> getBlockSphere(BlockPos centre, double radius) {
        ArrayList<BlockPos> sphere = new ArrayList<BlockPos>((int)Math.pow(radius, 3.0));
        int i = -((int)radius);
        while ((double)i <= radius) {
            float r1 = Mth.m_14116_((float)((float)(radius * radius - (double)(i * i))));
            int j = -((int)r1);
            while ((float)j <= r1) {
                float r2 = Mth.m_14116_((float)((float)(radius * radius - (double)(i * i) - (double)(j * j))));
                int k = -((int)r2);
                while ((float)k <= r2) {
                    sphere.add(centre.m_7918_(i, j, k));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return sphere;
    }

    @Nullable
    public static Integer getNearestSurface(Level world, BlockPos pos, Direction direction, int range, boolean doubleSided, SurfaceCriteria criteria) {
        int i;
        Integer surface = null;
        int currentBest = Integer.MAX_VALUE;
        int n = i = doubleSided ? -range : 0;
        while (i <= range && i < currentBest) {
            BlockPos testPos = pos.m_5484_(direction, i);
            if (criteria.test(world, testPos, direction)) {
                surface = (int)GeometryUtil.component(GeometryUtil.getFaceCentre(testPos, direction), direction.m_122434_());
                currentBest = Math.abs(i);
            }
            ++i;
        }
        return surface;
    }

    public static boolean freeze(Level world, BlockPos pos, boolean freezeLava) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (state.m_60734_() == Blocks.f_49990_ && (Integer)state.m_61143_((Property)LiquidBlock.f_54688_) == 0) {
            world.m_46597_(pos, Blocks.f_50126_.m_49966_());
        } else if (freezeLava && state.m_60734_() == Blocks.f_49991_ && (Integer)state.m_61143_((Property)LiquidBlock.f_54688_) == 0) {
            world.m_46597_(pos, Blocks.f_50080_.m_49966_());
        } else if (freezeLava && block == Blocks.f_49991_) {
            world.m_46597_(pos, Blocks.f_50652_.m_49966_());
        } else if (BlockUtil.canBlockBeReplaced(world, pos.m_7494_()) && Blocks.f_50125_.m_49966_().m_60710_((LevelReader)world, pos.m_7494_())) {
            world.m_46597_(pos.m_7494_(), Blocks.f_50125_.m_49966_());
        } else {
            return false;
        }
        return true;
    }

    public static boolean isBlockPassable(Level world, BlockPos checkPos) {
        return world.m_46859_(checkPos) || world.m_8055_(checkPos).m_247087_();
    }

    @FunctionalInterface
    public static interface SurfaceCriteria {
        public static final SurfaceCriteria COLLIDABLE = SurfaceCriteria.basedOn(BlockBehaviour.BlockStateBase::m_280555_);
        public static final SurfaceCriteria BUILDABLE = (world, pos, side) -> world.m_8055_(pos).m_60783_((BlockGetter)world, pos, side) && world.m_8055_(pos.m_121945_(side)).m_247087_();
        public static final SurfaceCriteria SOLID_LIQUID_TO_AIR = (world, pos, side) -> world.m_8055_(pos).m_278721_() || world.m_8055_(pos).m_60783_((BlockGetter)world, pos, side) && world.m_46859_(pos.m_121945_(side));
        public static final SurfaceCriteria NOT_AIR_TO_AIR = SurfaceCriteria.basedOn(LevelReader::m_46859_).flip();

        public static SurfaceCriteria basedOn(BiPredicate<Level, BlockPos> condition) {
            return (world, pos, side) -> condition.test(world, pos) && !condition.test(world, pos.m_121945_(side));
        }

        public static SurfaceCriteria basedOn(Predicate<BlockState> condition) {
            return (world, pos, side) -> condition.test(world.m_8055_(pos)) && !condition.test(world.m_8055_(pos.m_121945_(side)));
        }

        public boolean test(Level var1, BlockPos var2, Direction var3);

        default public SurfaceCriteria flip() {
            return (world, pos, side) -> this.test(world, pos.m_121945_(side), side.m_122424_());
        }
    }
}

