/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.util;

import com.binaris.wizardry.api.content.event.SpellCastEvent;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.core.event.WizardryEventBus;
import com.binaris.wizardry.core.networking.s2c.SpellCastS2C;
import com.binaris.wizardry.core.platform.Services;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public final class CastUtils {
    public static boolean fireSpellCastEvent(SpellCastEvent.Source source, Spell spell, PlayerCastContext ctx) {
        SpellCastEvent event = ctx.castingTicks() == 0 ? new SpellCastEvent.Pre(source, spell, (LivingEntity)ctx.caster(), ctx.modifiers()) : new SpellCastEvent.Tick(source, spell, (LivingEntity)ctx.caster(), ctx.modifiers(), ctx.castingTicks());
        return WizardryEventBus.getInstance().fire(event);
    }

    public static void applyCooldownForfeit(Player caster, int cooldownTicks) {
        caster.m_36335_().m_41524_(caster.m_21211_().m_41720_(), cooldownTicks);
    }

    public static void trackSpellUsage(Player caster, Spell spell) {
        Services.OBJECT_DATA.getWizardData(caster).trackRecentSpell(spell, caster.m_9236_().m_46467_());
    }

    public static boolean executeSpellCast(SpellCastEvent.Source source, Spell spell, PlayerCastContext ctx) {
        if (!spell.cast(ctx)) {
            return false;
        }
        if (ctx.castingTicks() == 0) {
            WizardryEventBus.getInstance().fire(new SpellCastEvent.Post(source, spell, (LivingEntity)ctx.caster(), ctx.modifiers()));
        }
        return true;
    }

    public static void sendSpellCastPacket(Player caster, Spell spell, PlayerCastContext ctx) {
        if (!ctx.world().f_46443_ && spell.requiresPacket()) {
            SpellCastS2C msg = new SpellCastS2C(caster.m_19879_(), ctx.hand(), spell, ctx.modifiers());
            Services.NETWORK_HELPER.sendToDimension(ctx.world().m_7654_(), msg, (ResourceKey<Level>)ctx.world().m_46472_());
        }
    }

    private CastUtils() {
    }
}

