/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;

public class DrawingUtils {
    public static void drawTexturedRectF(PoseStack poseStack, float x, float y, float u, float v, float width, float height, float textureWidth, float textureHeight) {
        DrawingUtils.drawTexturedFlippedRectF(poseStack, x, y, u, v, width, height, textureWidth, textureHeight, false, false);
    }

    public static void drawTexturedFlippedRectF(PoseStack poseStack, float x, float y, float u, float v, float width, float height, float textureWidth, float textureHeight, boolean flipX, boolean flipY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        float f = 1.0f / textureWidth;
        float f1 = 1.0f / textureHeight;
        float u1 = flipX ? u + width : u;
        float u2 = flipX ? u : u + width;
        float v1 = flipY ? v + height : v;
        float v2 = flipY ? v : v + height;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), x, y + height, 0.0f).m_7421_(u1 * f, v2 * f1).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), x + width, y + height, 0.0f).m_7421_(u2 * f, v2 * f1).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), x + width, y, 0.0f).m_7421_(u2 * f, v1 * f1).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), x, y, 0.0f).m_7421_(u1 * f, v1 * f1).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
    }

    public static float smoothScaleFactor(int lifetime, int ticksExisted, float partialTicks, int startLength, int endLength) {
        float age = (float)ticksExisted + partialTicks;
        float s = Mth.m_14036_((float)(age < (float)startLength || lifetime < 0 ? age / (float)startLength : ((float)lifetime - age) / (float)endLength), (float)0.0f, (float)1.0f);
        s = (float)Math.pow(s, 0.4);
        return s;
    }

    public static int mix(int colour1, int colour2, float proportion) {
        proportion = Mth.m_14036_((float)proportion, (float)0.0f, (float)1.0f);
        int r1 = colour1 >> 16 & 0xFF;
        int g1 = colour1 >> 8 & 0xFF;
        int b1 = colour1 & 0xFF;
        int r2 = colour2 >> 16 & 0xFF;
        int g2 = colour2 >> 8 & 0xFF;
        int b2 = colour2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * proportion);
        int g = (int)((float)g1 + (float)(g2 - g1) * proportion);
        int b = (int)((float)b1 + (float)(b2 - b1) * proportion);
        return (r << 16) + (g << 8) + b;
    }

    public static void drawGlitchRect(Random random, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, boolean flipX, boolean flipY) {
        for (int i = 0; i < height; ++i) {
            if (flipY) {
                i = height - i - 1;
            }
            int offset = random.nextInt(4) == 0 ? random.nextInt(6) - 3 : 0;
            DrawingUtils.drawTexturedFlippedRect(x + offset, y + i, u, v + i, width, 1, textureWidth, textureHeight, flipX, flipY);
        }
    }

    public static void drawTexturedFlippedRect(float x, float y, int u, int v, int width, int height, int textureWidth, int textureHeight, boolean flipX, boolean flipY) {
        PoseStack stack = new PoseStack();
        RenderSystem.setShader(GameRenderer::m_172817_);
        float f = 1.0f / (float)textureWidth;
        float f1 = 1.0f / (float)textureHeight;
        int u1 = flipX ? u + width : u;
        int u2 = flipX ? u : u + width;
        int v1 = flipY ? v + height : v;
        int v2 = flipY ? v : v + height;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_252986_(stack.m_85850_().m_252922_(), x, y + (float)height, 0.0f).m_7421_((float)u1 * f, (float)v2 * f1).m_5752_();
        buffer.m_252986_(stack.m_85850_().m_252922_(), x + (float)width, y + (float)height, 0.0f).m_7421_((float)u2 * f, (float)v2 * f1).m_5752_();
        buffer.m_252986_(stack.m_85850_().m_252922_(), x + (float)width, y, 0.0f).m_7421_((float)u2 * f, (float)v1 * f1).m_5752_();
        buffer.m_252986_(stack.m_85850_().m_252922_(), x, y, 0.0f).m_7421_((float)u1 * f, (float)v1 * f1).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
    }

    public static void drawTexturedRect(float x, float y, int width, int height) {
        DrawingUtils.drawTexturedRect(x, y, 0, 0, width, height, width, height);
    }

    public static void drawTexturedRect(float x, float y, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        DrawingUtils.drawTexturedFlippedRect(x, y, u, v, width, height, textureWidth, textureHeight, false, false);
    }

    public static int makeTranslucent(int colour, float opacity) {
        return colour + ((int)(opacity * 255.0f) << 24);
    }

    public static void drawScaledStringToWidth(GuiGraphics guiGraphics, Font font, Component text, float x, float y, float scale, int colour, float width, boolean centre, boolean alignR) {
        float textWidth = (float)font.m_92852_((FormattedText)text) * scale;
        Objects.requireNonNull(font);
        float textHeight = 9.0f * scale;
        if (textWidth > width) {
            scale *= width / textWidth;
            font.m_92852_((FormattedText)text);
        } else if (alignR) {
            x += width - textWidth;
        }
        if (centre) {
            Objects.requireNonNull(font);
            y += (9.0f - textHeight) / 2.0f;
        }
        DrawingUtils.drawScaledTranslucentString(guiGraphics, font, text, x, y, scale, colour);
    }

    public static void drawScaledTranslucentString(GuiGraphics guiGraphics, Font font, Component text, float x, float y, float scale, int colour) {
        PoseStack stack = guiGraphics.m_280168_();
        stack.m_85836_();
        RenderSystem.enableBlend();
        stack.m_85841_(scale, scale, scale);
        float adjustedX = x / scale;
        float adjustedY = y / scale;
        guiGraphics.m_280430_(font, text, (int)adjustedX, (int)adjustedY, colour);
        RenderSystem.disableBlend();
        stack.m_85849_();
    }
}

