/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.util;

import com.binaris.wizardry.api.content.entity.living.ISpellCaster;
import com.binaris.wizardry.api.content.item.ISpellCastingItem;
import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellContext;
import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.api.content.util.GeometryUtil;
import com.binaris.wizardry.api.content.util.SpellUtil;
import com.binaris.wizardry.content.item.ScrollItem;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.google.common.collect.Streams;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class EntityUtil {
    private EntityUtil() {
    }

    public static void undoGravity(Entity entity) {
        if (!entity.m_20068_()) {
            double gravity = 0.04;
            if (entity instanceof ThrowableProjectile) {
                gravity = 0.03;
            } else if (entity instanceof Arrow) {
                gravity = 0.05;
            } else if (entity instanceof LivingEntity) {
                gravity = 0.08;
            }
            entity.m_20256_(entity.m_20184_().m_82520_(0.0, gravity, 0.0));
        }
    }

    @Nullable
    public static Entity getEntityByUUID(Level world, @Nullable UUID id) {
        if (id == null) {
            return null;
        }
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            for (Entity entity : serverWorld.m_8583_()) {
                if (!entity.m_20148_().equals(id)) continue;
                return entity;
            }
        }
        return null;
    }

    public static List<LivingEntity> getLivingEntitiesInRange(Level world, double x, double y, double z, double range) {
        return EntityUtil.getEntitiesInRange(world, x, y, z, range, LivingEntity.class);
    }

    public static List<LivingEntity> getLivingWithinRadius(double radius, double x, double y, double z, Level world) {
        return EntityUtil.getEntitiesWithinRadius(radius, x, y, z, world, LivingEntity.class);
    }

    public static <T extends Entity> List<T> getEntitiesInRange(Level world, double x, double y, double z, double range, Class<T> entityClass) {
        AABB boundingBox = new AABB(x - range, y - range, z - range, x + range, y + range, z + range);
        Predicate<Entity> alwaysTrue = entity -> true;
        List entities = world.m_6443_(entityClass, boundingBox, alwaysTrue);
        double rangeSq = range * range;
        entities.removeIf(entity -> entity.m_20275_(x, y, z) > rangeSq);
        return entities;
    }

    public static <T extends Entity> List<T> getEntitiesWithinRadius(double radius, double x, double y, double z, Level world, Class<T> entityType) {
        AABB box = new AABB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
        List entityList = world.m_45976_(entityType, box);
        double radiusSq = radius * radius;
        entityList.removeIf(entity -> entity.m_20275_(x, y, z) > radiusSq);
        return entityList;
    }

    public static boolean isLiving(Entity entity) {
        return entity instanceof LivingEntity && !(entity instanceof ArmorStand);
    }

    public static boolean attackEntityWithoutKnockback(Entity entity, DamageSource source, float amount) {
        Vec3 originalVec = entity.m_20184_();
        boolean succeeded = entity.m_6469_(source, amount);
        entity.m_20256_(originalVec);
        return succeeded;
    }

    @Nullable
    public static Entity getRider(Entity entity) {
        return !entity.m_20197_().isEmpty() ? (Entity)entity.m_20197_().get(0) : null;
    }

    public static Vec3 findSpaceForTeleport(Entity entity, Vec3 destination, boolean accountForPassengers) {
        Level world = entity.m_9236_();
        AABB box = entity.m_20191_();
        if (accountForPassengers) {
            for (Entity passenger : entity.m_20197_()) {
                box = box.m_82367_(passenger.m_20191_());
            }
        }
        box = box.m_82383_(destination.m_82492_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()));
        Iterable cuboid = BlockPos.m_121976_((int)Mth.m_14107_((double)box.f_82288_), (int)Mth.m_14107_((double)box.f_82289_), (int)Mth.m_14107_((double)box.f_82290_), (int)Mth.m_14107_((double)box.f_82291_), (int)Mth.m_14107_((double)box.f_82292_), (int)Mth.m_14107_((double)box.f_82293_));
        if (Streams.stream((Iterable)cuboid).allMatch(b -> world.m_45772_(new AABB(b)))) {
            return destination;
        }
        double dx = box.f_82291_ - box.f_82288_;
        double dy = box.f_82292_ - box.f_82289_;
        double dz = box.f_82293_ - box.f_82290_;
        int nx = Mth.m_14165_((double)dx) / 2;
        int px = Mth.m_14165_((double)dx) - nx;
        int ny = Mth.m_14165_((double)dy) / 2;
        int py = Mth.m_14165_((double)dy) - ny;
        int nz = Mth.m_14165_((double)dz) / 2;
        int pz = Mth.m_14165_((double)dz) - nz;
        List nearby = Streams.stream((Iterable)BlockPos.m_121976_((int)(Mth.m_14107_((double)box.f_82288_) - 1), (int)(Mth.m_14107_((double)box.f_82289_) - 1), (int)(Mth.m_14107_((double)box.f_82290_) - 1), (int)(Mth.m_14107_((double)box.f_82291_) + 1), (int)(Mth.m_14107_((double)box.f_82292_) + 1), (int)(Mth.m_14107_((double)box.f_82293_) + 1))).collect(Collectors.toList());
        List possiblePositions = Streams.stream((Iterable)cuboid).collect(Collectors.toList());
        while (!nearby.isEmpty()) {
            BlockPos pos = (BlockPos)nearby.remove(0);
            if (world.m_45772_(new AABB(pos))) continue;
            Predicate<BlockPos> nearSolidBlock = b -> b.m_123341_() >= pos.m_123341_() - nx && b.m_123341_() <= pos.m_123341_() + px && b.m_123342_() >= pos.m_123342_() - ny && b.m_123342_() <= pos.m_123342_() + py && b.m_123343_() >= pos.m_123343_() - nz && b.m_123343_() <= pos.m_123343_() + pz;
            nearby.removeIf(nearSolidBlock);
            possiblePositions.removeIf(nearSolidBlock);
        }
        if (possiblePositions.isEmpty()) {
            return null;
        }
        BlockPos nearest = possiblePositions.stream().min(Comparator.comparingDouble(b -> destination.m_82531_((double)b.m_123341_() + 0.5, (double)b.m_123342_() + 0.5, (double)b.m_123343_() + 0.5))).get();
        return GeometryUtil.getFaceCentre(nearest, Direction.DOWN);
    }

    public static List<LivingEntity> getLivingWithinCylinder(double radius, double x, double y, double z, double height, Level world) {
        return EntityUtil.getEntitiesWithinCylinder(radius, x, y, z, height, world, LivingEntity.class);
    }

    public static <T extends Entity> List<T> getEntitiesWithinCylinder(double radius, double x, double y, double z, double height, Level world, Class<T> entityType) {
        AABB aabb = new AABB(x - radius, y, z - radius, x + radius, y + height, z + radius);
        List entityList = world.m_45976_(entityType, aabb);
        double radiusSq = radius * radius;
        entityList.removeIf(entity -> entity.m_20275_(x, entity.f_19855_, z) > radiusSq);
        return entityList;
    }

    public static boolean canDamageBlocks(LivingEntity entity, Level world) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.m_36326_() && !player.m_5833_();
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            return !Services.PLATFORM.fireMobBlockBreakEvent(world, null, mob);
        }
        return false;
    }

    public static int getDefaultAimingError(Difficulty difficulty) {
        return switch (difficulty) {
            case Difficulty.EASY -> 5;
            case Difficulty.NORMAL -> 3;
            case Difficulty.HARD -> 0;
            default -> 4;
        };
    }

    public static void playSoundAtPlayer(Player player, SoundEvent sound, float volume, float pitch) {
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), sound, SoundSource.PLAYERS, volume, pitch);
    }

    public static boolean isCasting(LivingEntity caster, Spell spell) {
        if (spell.isInstantCast()) {
            return false;
        }
        if (caster instanceof Player) {
            if (caster.m_6117_()) {
                ItemStack stack = caster.m_21120_(caster.m_7655_());
                boolean isSpellCastingItem = stack.m_41720_() instanceof ISpellCastingItem;
                if (!isSpellCastingItem) {
                    return false;
                }
                Spell currentSpell = ((ISpellCastingItem)stack.m_41720_()).getCurrentSpell(stack);
                if (stack.m_41720_() instanceof ScrollItem) {
                    return currentSpell == spell;
                }
                int ticksInUse = caster.m_21211_().m_41779_() - caster.m_21212_();
                if (ticksInUse >= spell.getCharge()) {
                    return currentSpell == spell;
                }
            }
        } else if (caster instanceof ISpellCaster) {
            ISpellCaster spellCaster = (ISpellCaster)caster;
            return spellCaster.getContinuousSpell() == spell;
        }
        return false;
    }

    public static SpellTier populateSpells(List<Spell> spells, Element e, boolean master, int n, RandomSource random) {
        SpellTier maxTier = SpellTiers.NOVICE;
        List<Spell> npcSpells = SpellUtil.getSpells(Spell::canCastByEntity);
        for (int i = 0; i < n; ++i) {
            Element element = e == Elements.MAGIC ? SpellUtil.getRandomElement(random) : e;
            int randomizer = random.m_188503_(20);
            SpellTier tier = randomizer < 10 ? SpellTiers.NOVICE : (randomizer < 16 ? SpellTiers.APPRENTICE : (randomizer < 19 || !master ? SpellTiers.ADVANCED : SpellTiers.MASTER));
            if (tier.level > maxTier.level) {
                maxTier = tier;
            }
            List<Spell> list = SpellUtil.getSpells(spell -> spell.getTier() == tier && spell.getElement() == element && spell.canCastByEntity() && spell.isEnabled(SpellContext.NPCS));
            list.retainAll(npcSpells);
            list.removeAll(spells);
            if (list.isEmpty()) {
                list = npcSpells;
                list.removeAll(spells);
            }
            if (list.isEmpty()) continue;
            spells.add(list.get(random.m_188503_(list.size())));
        }
        return maxTier;
    }

    public static ItemStack getWandInUse(Player player) {
        ItemStack wand = player.m_21205_();
        if (!(wand.m_41720_() instanceof ISpellCastingItem && ((ISpellCastingItem)wand.m_41720_()).getSpells(wand).length >= 2 || (wand = player.m_21206_()).m_41720_() instanceof ISpellCastingItem && ((ISpellCastingItem)wand.m_41720_()).getSpells(wand).length >= 2)) {
            return null;
        }
        return wand;
    }

    public static void applyStandardKnockback(Entity attacker, LivingEntity target, float strength) {
        double dx = attacker.m_20185_() - target.m_20185_();
        double dz = attacker.m_20189_() - target.m_20189_();
        while (dx * dx + dz * dz < 1.0E-4) {
            dx = (Math.random() - Math.random()) * 0.01;
            dz = (Math.random() - Math.random()) * 0.01;
        }
        target.m_147240_((double)strength, dx, dz);
    }
}

