/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.util;

import com.binaris.wizardry.api.content.item.IManaStoringItem;
import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.content.item.WizardArmorItem;
import com.binaris.wizardry.content.item.WizardArmorType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class InventoryUtil {
    public static final EquipmentSlot[] ARMOR_SLOTS;

    public static Collection<ItemStack> getAllItems(Player player) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.addAll((Collection<ItemStack>)player.m_150109_().f_35974_);
        items.addAll((Collection<ItemStack>)player.m_150109_().f_35975_);
        items.addAll((Collection<ItemStack>)player.m_150109_().f_35976_);
        return items;
    }

    public static List<ItemStack> getHotBarAndOffhand(Player player) {
        List<ItemStack> hotbar = InventoryUtil.getHotbar(player);
        hotbar.add(0, player.m_21206_());
        hotbar.remove(player.m_21205_());
        hotbar.add(0, player.m_21205_());
        return hotbar;
    }

    public static boolean doesPlayerHaveItem(Player player, Item item) {
        for (ItemStack stack : InventoryUtil.getAllItems(player)) {
            if (stack == null || !stack.m_150930_(item)) continue;
            return true;
        }
        return false;
    }

    public static List<ItemStack> getHotbar(Player player) {
        NonNullList hotBar = NonNullList.m_122779_();
        hotBar.addAll((Collection)player.m_150109_().f_35974_.subList(0, 9));
        return hotBar;
    }

    public static boolean isWearingFullSet(LivingEntity entity, @Nullable Element element, @Nullable WizardArmorType armor) {
        ItemStack helmet = entity.m_6844_(EquipmentSlot.HEAD);
        Item item = helmet.m_41720_();
        if (!(item instanceof WizardArmorItem)) {
            return false;
        }
        WizardArmorItem wizardArmor = (WizardArmorItem)item;
        Element e = element == null ? wizardArmor.getElement() : element;
        WizardArmorType ac = armor == null ? wizardArmor.getWizardArmorType() : armor;
        return Arrays.stream(ARMOR_SLOTS).allMatch(slot -> {
            WizardArmorItem armor2;
            Item patt2768$temp = entity.m_6844_(slot).m_41720_();
            return patt2768$temp instanceof WizardArmorItem && (armor2 = (WizardArmorItem)patt2768$temp).getElement() == e && armor2.getWizardArmorType() == ac;
        });
    }

    public static boolean doAllArmourPiecesHaveMana(LivingEntity entity) {
        return Arrays.stream(ARMOR_SLOTS).noneMatch(s -> {
            IManaStoringItem manaStoringItem;
            Item patt3090$temp = entity.m_6844_(s).m_41720_();
            return patt3090$temp instanceof IManaStoringItem && (manaStoringItem = (IManaStoringItem)patt3090$temp).isManaEmpty(entity.m_6844_(s));
        });
    }

    static {
        ArrayList<EquipmentSlot> slots = new ArrayList<EquipmentSlot>(Arrays.asList(EquipmentSlot.values()));
        slots.removeIf(slot -> slot.m_20743_() != EquipmentSlot.Type.ARMOR);
        ARMOR_SLOTS = slots.toArray(new EquipmentSlot[0]);
    }
}

