/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.util;

import com.binaris.wizardry.content.entity.living.IceGiant;
import com.binaris.wizardry.content.entity.living.IceWraith;
import com.binaris.wizardry.content.entity.living.LightningWraith;
import com.binaris.wizardry.content.entity.living.ShadowWraith;
import com.binaris.wizardry.content.entity.living.StormElemental;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import org.jetbrains.annotations.Nullable;

public class MagicDamageSource
extends DamageSource {
    private static final Map<Class<? extends Entity>, Set<ResourceKey<DamageType>>> IMMUNITY_MAPPING = new HashMap<Class<? extends Entity>, Set<ResourceKey<DamageType>>>();

    public MagicDamageSource(Holder<DamageType> damageTypeHolder, @Nullable Entity directEntity, @Nullable Entity causingEntity) {
        super(damageTypeHolder, directEntity, causingEntity);
    }

    @SafeVarargs
    public static void setEntityImmunities(Class<? extends Entity> entityType, ResourceKey<DamageType> ... immunities) {
        IMMUNITY_MAPPING.computeIfAbsent(entityType, k -> new HashSet()).addAll(Arrays.asList(immunities));
    }

    public static boolean isEntityImmune(ResourceKey<DamageType> type, Entity entity) {
        if (type == EBDamageSources.FIRE && entity.m_5825_()) {
            return true;
        }
        Set<ResourceKey<DamageType>> immunities = IMMUNITY_MAPPING.get(entity.getClass());
        return immunities != null && immunities.contains(type);
    }

    public static boolean causeMagicDamage(Entity caster, Entity target, float damage, ResourceKey<DamageType> type) {
        Entity owner = MagicDamageSource.getOwnerIfPresent(caster);
        DamageSource source = owner != null ? MagicDamageSource.causeIndirectMagicDamage(caster, owner, type) : MagicDamageSource.causeDirectMagicDamage(caster, type);
        return target.m_6469_(source, damage);
    }

    @Nullable
    private static Entity getOwnerIfPresent(Entity entity) {
        TraceableEntity traceable;
        OwnableEntity ownable;
        if (entity instanceof OwnableEntity && (ownable = (OwnableEntity)entity).m_269323_() != null) {
            return ownable.m_269323_();
        }
        if (entity instanceof TraceableEntity && (traceable = (TraceableEntity)entity).m_19749_() != null) {
            return traceable.m_19749_();
        }
        return null;
    }

    public static DamageSource causeDirectMagicDamage(Entity caster, ResourceKey<DamageType> type) {
        return MagicDamageSource.createMagicDamage(caster, null, type);
    }

    public static DamageSource causeIndirectMagicDamage(Entity magic, Entity caster, ResourceKey<DamageType> type) {
        return MagicDamageSource.createMagicDamage(magic, caster, type);
    }

    private static DamageSource createMagicDamage(Entity source, Entity indirect, ResourceKey<DamageType> type) {
        Holder.Reference holder = source.m_9236_().m_9598_().m_255025_(Registries.f_268580_).m_255043_(type);
        return new MagicDamageSource((Holder<DamageType>)holder, source, indirect);
    }

    static {
        MagicDamageSource.setEntityImmunities(Blaze.class, EBDamageSources.FIRE);
        MagicDamageSource.setEntityImmunities(ZombifiedPiglin.class, EBDamageSources.FIRE, EBDamageSources.POISON);
        MagicDamageSource.setEntityImmunities(MagmaCube.class, EBDamageSources.FIRE);
        MagicDamageSource.setEntityImmunities(Ghast.class, EBDamageSources.FIRE);
        MagicDamageSource.setEntityImmunities(EnderDragon.class, EBDamageSources.FIRE);
        MagicDamageSource.setEntityImmunities(WitherBoss.class, EBDamageSources.FIRE, EBDamageSources.WITHER);
        MagicDamageSource.setEntityImmunities(SnowGolem.class, EBDamageSources.FROST);
        MagicDamageSource.setEntityImmunities(PolarBear.class, EBDamageSources.FROST);
        MagicDamageSource.setEntityImmunities(WitherSkeleton.class, EBDamageSources.WITHER);
        MagicDamageSource.setEntityImmunities(Spider.class, EBDamageSources.POISON);
        MagicDamageSource.setEntityImmunities(CaveSpider.class, EBDamageSources.POISON);
        MagicDamageSource.setEntityImmunities(Zombie.class, EBDamageSources.POISON);
        MagicDamageSource.setEntityImmunities(Skeleton.class, EBDamageSources.POISON);
        MagicDamageSource.setEntityImmunities(IceWraith.class, EBDamageSources.FROST);
        MagicDamageSource.setEntityImmunities(IceGiant.class, EBDamageSources.FROST);
        MagicDamageSource.setEntityImmunities(LightningWraith.class, EBDamageSources.SHOCK);
        MagicDamageSource.setEntityImmunities(ShadowWraith.class, EBDamageSources.WITHER);
        MagicDamageSource.setEntityImmunities(StormElemental.class, EBDamageSources.FIRE, EBDamageSources.SHOCK);
    }
}

