/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.util;

import com.binaris.wizardry.api.EBLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public final class NBTExtras {
    private NBTExtras() {
    }

    public static void storeTagSafely(CompoundTag compound, String key, Tag tag) {
        if (compound == tag || NBTExtras.deepContains(tag, (Tag)compound)) {
            EBLogger.error("Cannot store tag of type %s under key '{}' as it would result in a circular reference! Please report this (including your full log) to wizardry's issue tracker.", NBTExtras.getTagTypeName(tag.m_7060_()), key);
        } else {
            compound.m_128365_(key, tag);
        }
    }

    public static boolean deepContains(Tag toSearch, Tag searchFor) {
        block3: {
            block2: {
                if (!(toSearch instanceof CompoundTag)) break block2;
                for (String subKey : ((CompoundTag)toSearch).m_128431_()) {
                    Tag subTag = ((CompoundTag)toSearch).m_128423_(subKey);
                    if (subTag != searchFor && !NBTExtras.deepContains(subTag, searchFor)) continue;
                    return true;
                }
                break block3;
            }
            if (!(toSearch instanceof ListTag)) break block3;
            for (Tag subTag : (ListTag)toSearch) {
                if (subTag != searchFor && !NBTExtras.deepContains(subTag, searchFor)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getTagTypeName(int id) {
        return switch (id) {
            case 0 -> "TAG_End";
            case 1 -> "TAG_Byte";
            case 2 -> "TAG_Short";
            case 3 -> "TAG_Int";
            case 4 -> "TAG_Long";
            case 5 -> "TAG_Float";
            case 6 -> "TAG_Double";
            case 7 -> "TAG_Byte_Array";
            case 8 -> "TAG_String";
            case 9 -> "TAG_List";
            case 10 -> "TAG_Compound";
            case 11 -> "TAG_Int_Array";
            case 12 -> "TAG_Long_Array";
            case 99 -> "Any Numeric Tag";
            default -> "UNKNOWN";
        };
    }

    public static <E, T extends Tag> ListTag listToTag(Collection<E> list, Function<E, T> mapper) {
        ListTag tagList = new ListTag();
        for (E element : list) {
            tagList.add((Object)((Tag)mapper.apply(element)));
        }
        return tagList;
    }

    public static <E, T extends Tag> Collection<E> tagToList(ListTag tagList, Function<T, E> function) {
        ArrayList<E> list = new ArrayList<E>();
        ListTag tagList2 = tagList.m_6426_();
        while (!tagList2.isEmpty()) {
            Tag tag = tagList2.remove(0);
            try {
                list.add(function.apply(tag));
            }
            catch (ClassCastException e) {
                EBLogger.error("Error when reading list from NBT: unexpected tag type " + NBTExtras.getTagTypeName(tag.m_7060_()), e);
            }
        }
        return list;
    }
}

