/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.util;

import com.binaris.wizardry.api.content.entity.ICustomHitbox;
import com.binaris.wizardry.api.content.util.EntityUtil;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RayTracer {
    @NotNull
    public static HitResult rayTrace(Level world, Entity caster, Vec3 origin, Vec3 endpoint, float aimAssist, boolean hitLiquids, Class<? extends Entity> entityType, Predicate<? super Entity> filter) {
        ClipContext.Fluid fluidMode = hitLiquids ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE;
        BlockHitResult blockHit = world.m_45547_(new ClipContext(origin, endpoint, ClipContext.Block.COLLIDER, fluidMode, caster));
        Vec3 traceEnd = blockHit.m_82450_();
        float searchRadius = 1.0f + aimAssist;
        AABB searchVolume = new AABB(origin.f_82479_, origin.f_82480_, origin.f_82481_, traceEnd.f_82479_, traceEnd.f_82480_, traceEnd.f_82481_).m_82377_((double)searchRadius, (double)searchRadius, (double)searchRadius);
        List entities = world.m_45976_(entityType, searchVolume);
        entities.removeIf(filter);
        Entity closestEntity = null;
        double closestDistance = origin.m_82554_(traceEnd);
        for (Entity entity : entities) {
            double distance;
            Vec3 intercept = RayTracer.calculateIntercept(entity, origin, traceEnd, aimAssist);
            if (intercept == null || !((distance = origin.m_82554_(intercept)) < closestDistance)) continue;
            closestEntity = entity;
            closestDistance = distance;
        }
        return closestEntity != null ? new EntityHitResult(closestEntity) : blockHit;
    }

    @Nullable
    private static Vec3 calculateIntercept(Entity entity, Vec3 origin, Vec3 endpoint, float aimAssist) {
        if (entity instanceof ICustomHitbox) {
            ICustomHitbox customHitbox = (ICustomHitbox)entity;
            float fuzziness = EntityUtil.isLiving(entity) ? aimAssist : 0.0f;
            return customHitbox.calculateIntercept(origin, endpoint, fuzziness);
        }
        AABB bounds = entity.m_20191_();
        float pickRadius = entity.m_6143_();
        if (pickRadius != 0.0f) {
            bounds = bounds.m_82400_((double)pickRadius);
        }
        if (EntityUtil.isLiving(entity) && aimAssist != 0.0f) {
            bounds = bounds.m_82400_((double)aimAssist);
        }
        return bounds.m_82371_(origin, endpoint).orElse(null);
    }

    @NotNull
    public static HitResult standardBlockRayTrace(Level world, LivingEntity entity, double range, boolean hitLiquids, boolean ignoreUncollidables, boolean returnLastUncollidable) {
        Vec3 origin = entity.m_20299_(1.0f);
        Vec3 endpoint = origin.m_82549_(entity.m_20154_().m_82490_(range));
        ClipContext.Fluid fluidMode = hitLiquids ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE;
        return world.m_45547_(new ClipContext(origin, endpoint, ClipContext.Block.COLLIDER, fluidMode, (Entity)entity));
    }

    public static Predicate<Entity> ignoreEntityFilter(@Nullable Entity entity) {
        return e -> {
            if (e == entity) return true;
            if (!(e instanceof LivingEntity)) return false;
            LivingEntity living = (LivingEntity)e;
            if (living.f_20919_ <= 0) return false;
            return true;
        };
    }
}

