/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.util;

import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.api.content.util.InventoryUtil;
import com.binaris.wizardry.content.item.WizardArmorType;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RegistryUtils {
    private RegistryUtils() {
    }

    public static Item getWand(@NotNull SpellTier tier, @Nullable Element element) {
        Object registryName;
        if (element == null) {
            element = Elements.MAGIC;
        }
        Object object = registryName = tier == SpellTiers.NOVICE && element == Elements.MAGIC ? "novice" : tier.getOrCreateLocation().m_135815_();
        if (element != Elements.MAGIC) {
            registryName = (String)registryName + "_" + element.getLocation().m_135815_();
        }
        registryName = "wand_" + (String)registryName;
        return (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(element.getLocation().m_135827_(), (String)registryName));
    }

    public static Item getCrystal(Element element) {
        Object registryName = "magic_crystal";
        if (element != null && element != Elements.MAGIC) {
            registryName = (String)registryName + "_" + element.getLocation().m_135815_();
        }
        return (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(element.getLocation().m_135827_(), (String)registryName));
    }

    public static Item getArmor(WizardArmorType type, Element element, RandomSource randomSource) {
        EquipmentSlot randomArmorSlot = InventoryUtil.ARMOR_SLOTS[randomSource.m_188503_(InventoryUtil.ARMOR_SLOTS.length)];
        return RegistryUtils.getArmor(type, element, randomArmorSlot);
    }

    public static Item getArmor(WizardArmorType wizardArmorType, Element element, EquipmentSlot slot) {
        if (slot == null || slot.m_20743_() != EquipmentSlot.Type.ARMOR) {
            throw new IllegalArgumentException("Must be a valid armour slot");
        }
        if (element == null) {
            element = Elements.MAGIC;
        }
        String registryName = wizardArmorType.m_6082_() + "_" + wizardArmorType.getArmourPieceNames().get(slot);
        if (element != Elements.MAGIC) {
            registryName = registryName + "_" + element.getLocation().m_135815_();
        }
        return (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(element.getLocation().m_135827_(), registryName));
    }
}

