/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.util;

import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.api.content.util.RegistryUtils;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Spells;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public final class SpellUtil {
    public static String SPELL_KEY = "Spell";

    private SpellUtil() {
    }

    public static List<Spell> getSpells(Predicate<Spell> filter) {
        return Services.REGISTRY_UTIL.getSpells().stream().filter(filter.and(s -> s != Spells.NONE)).collect(Collectors.toList());
    }

    public static Element getRandomElement(RandomSource random) {
        return Services.REGISTRY_UTIL.getElements().stream().toList().get(random.m_188503_(Services.REGISTRY_UTIL.getElements().size()));
    }

    public static ItemStack setSpell(ItemStack stack, Spell spell) {
        stack.m_41784_().m_128359_(SPELL_KEY, spell.getLocation().toString());
        return stack;
    }

    public static ItemStack spellBookItem(Spell spell) {
        ItemStack stack = new ItemStack((ItemLike)EBItems.SPELL_BOOK.get(), 1);
        SpellUtil.setSpell(stack, spell);
        return stack;
    }

    public static ItemStack wandItem(SpellTier tier, Element element) {
        return new ItemStack((ItemLike)RegistryUtils.getWand(tier, element));
    }

    public static ItemStack arcaneTomeItem(SpellTier tier) {
        ItemStack stack = new ItemStack((ItemLike)EBItems.ARCANE_TOME.get());
        stack.m_41784_().m_128359_("Tier", tier.getOrCreateLocation().toString());
        return stack;
    }

    @NotNull
    public static Spell getSpell(ItemStack stack) {
        return SpellUtil.getSpellFromNbt(stack.m_41784_());
    }

    private static Spell getSpellFromNbt(CompoundTag tag) {
        Spell byId = SpellUtil.byId(tag.m_128461_(SPELL_KEY));
        return byId == null ? Spells.NONE : byId;
    }

    private static Spell byId(String id) {
        return Services.REGISTRY_UTIL.getSpell(ResourceLocation.m_135820_((String)id));
    }
}

