/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.util;

import com.binaris.wizardry.api.content.data.SpellManagerData;
import com.binaris.wizardry.api.content.data.WizardData;
import com.binaris.wizardry.api.content.item.IElementValue;
import com.binaris.wizardry.api.content.item.ITierValue;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.SpellModifiers;
import com.binaris.wizardry.content.item.WandItem;
import com.binaris.wizardry.core.EBConstants;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.WandUpgrades;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class WandHelper {
    public static final String SPELL_ARRAY_KEY = "spells";
    public static final String SELECTED_SPELL_KEY = "selectedSpell";
    public static final String COOLDOWN_END_TIME_ARRAY_KEY = "cooldownEndTime";
    public static final String MAX_COOLDOWN_ARRAY_KEY = "maxCooldown";
    public static final String UPGRADES_KEY = "upgrades";
    public static final String PROGRESSION_KEY = "progression";
    private static final float SECOND_TIME_PROGRESSION_MODIFIER = 1.5f;

    private WandHelper() {
    }

    public static List<Spell> getSpells(ItemStack wand) {
        int maxSlots;
        Item item;
        ArrayList<Spell> spells = new ArrayList<Spell>();
        CompoundTag tag = wand.m_41784_();
        if (tag.m_128441_(SPELL_ARRAY_KEY)) {
            ListTag list = tag.m_128437_(SPELL_ARRAY_KEY, 8);
            for (Tag element : list) {
                StringTag stringTag;
                ResourceLocation location;
                if (!(element instanceof StringTag) || (location = ResourceLocation.m_135820_((String)(stringTag = (StringTag)element).m_7916_())) == null) continue;
                spells.add(Services.REGISTRY_UTIL.getSpell(location));
            }
        }
        if ((item = wand.m_41720_()) instanceof WandItem) {
            WandItem wandItem = (WandItem)item;
            v0 = wandItem.getSpellSlotCount(wand);
        } else {
            v0 = maxSlots = 5;
        }
        while (spells.size() < maxSlots) {
            spells.add(Spells.NONE);
        }
        return spells;
    }

    public static void setSpells(ItemStack wand, Collection<Spell> spells) {
        ListTag list = new ListTag();
        spells.forEach(spell -> list.add((Object)StringTag.m_129297_((String)spell.getLocation().toString())));
        wand.m_41784_().m_128365_(SPELL_ARRAY_KEY, (Tag)list);
    }

    public static Spell getCurrentSpell(ItemStack wand) {
        String tag = wand.m_41784_().m_128461_(SELECTED_SPELL_KEY);
        Spell spell = Services.REGISTRY_UTIL.getSpell(ResourceLocation.m_135820_((String)tag));
        return spell != null ? spell : Spells.NONE;
    }

    public static void setCurrentSpell(ItemStack wand, Spell spell) {
        wand.m_41784_().m_128359_(SELECTED_SPELL_KEY, spell.getLocation().toString());
    }

    public static Spell getNextSpell(ItemStack wand) {
        return WandHelper.getAdjacentSpell(wand, 1);
    }

    public static Spell getPreviousSpell(ItemStack wand) {
        return WandHelper.getAdjacentSpell(wand, -1);
    }

    private static Spell getAdjacentSpell(ItemStack wand, int offset) {
        List<Spell> spells = WandHelper.getSpells(wand);
        if (spells.isEmpty()) {
            return Spells.NONE;
        }
        int currentIndex = spells.indexOf(WandHelper.getCurrentSpell(wand));
        if (currentIndex == -1) {
            return spells.get(0);
        }
        int newIndex = (currentIndex + offset + spells.size()) % spells.size();
        return spells.get(newIndex);
    }

    public static boolean selectSpell(ItemStack wand, int index) {
        List<Spell> spells = WandHelper.getSpells(wand);
        if (spells.isEmpty()) {
            return false;
        }
        WandHelper.setCurrentSpell(wand, spells.get(index));
        return true;
    }

    public static long[] getCooldownEndTimes(ItemStack wand) {
        return wand.m_41784_().m_128467_(COOLDOWN_END_TIME_ARRAY_KEY);
    }

    public static void setCooldownEndTimes(ItemStack wand, long[] cooldownEndTimes) {
        wand.m_41784_().m_128388_(COOLDOWN_END_TIME_ARRAY_KEY, cooldownEndTimes);
    }

    public static int getCurrentCooldown(ItemStack wand, long currentGameTime) {
        long endTime;
        long[] endTimes = WandHelper.getCooldownEndTimes(wand);
        int selectedSpellIndex = WandHelper.getSpells(wand).indexOf(WandHelper.getCurrentSpell(wand));
        if (selectedSpellIndex >= 0 && selectedSpellIndex < endTimes.length && (endTime = endTimes[selectedSpellIndex]) > currentGameTime) {
            return (int)(endTime - currentGameTime);
        }
        return 0;
    }

    public static void setCurrentCooldown(ItemStack wand, int cooldown, long currentGameTime) {
        int spellCount;
        int selectedSpell = WandHelper.getSpells(wand).indexOf(WandHelper.getCurrentSpell(wand));
        if (selectedSpell >= (spellCount = WandHelper.getSpells(wand).size())) {
            return;
        }
        long[] endTimes = WandHelper.getCooldownEndTimes(wand);
        if (endTimes.length <= selectedSpell) {
            endTimes = new long[spellCount];
        }
        endTimes[selectedSpell] = currentGameTime + (long)Math.max(1, cooldown);
        WandHelper.setCooldownEndTimes(wand, endTimes);
        int[] maxCooldowns = WandHelper.getMaxCooldowns(wand);
        if (maxCooldowns.length <= selectedSpell) {
            maxCooldowns = new int[spellCount];
        }
        maxCooldowns[selectedSpell] = Math.max(1, cooldown);
        WandHelper.setMaxCooldowns(wand, maxCooldowns);
    }

    public static int[] getMaxCooldowns(ItemStack wand) {
        return wand.m_41784_().m_128465_(MAX_COOLDOWN_ARRAY_KEY);
    }

    public static void setMaxCooldowns(ItemStack wand, int[] cooldowns) {
        wand.m_41784_().m_128385_(MAX_COOLDOWN_ARRAY_KEY, cooldowns);
    }

    public static int getCurrentMaxCooldown(ItemStack wand) {
        int[] cooldowns = WandHelper.getMaxCooldowns(wand);
        int selectedSpell = WandHelper.getSpells(wand).indexOf(WandHelper.getCurrentSpell(wand));
        return selectedSpell >= 0 && selectedSpell < cooldowns.length ? cooldowns[selectedSpell] : 0;
    }

    public static int getUpgradeLevel(ItemStack wand, Item upgrade) {
        for (Map.Entry<Item, String> entry : WandUpgrades.getWandUpgrades().entrySet()) {
            if (!entry.getKey().equals(upgrade)) continue;
            return wand.m_41784_().m_128469_(UPGRADES_KEY).m_128451_(entry.getValue());
        }
        return 0;
    }

    public static int getTotalUpgrades(ItemStack wand) {
        return WandUpgrades.getWandUpgrades().keySet().stream().mapToInt(item -> WandHelper.getUpgradeLevel(wand, item)).sum();
    }

    public static void applyUpgrade(ItemStack wand, Item upgrade) {
        CompoundTag upgrades = wand.m_41784_().m_128469_(UPGRADES_KEY);
        if (upgrades.m_128456_()) {
            upgrades = new CompoundTag();
        }
        for (Map.Entry<Item, String> entry : WandUpgrades.getWandUpgrades().entrySet()) {
            if (!entry.getKey().equals(upgrade)) continue;
            String key = entry.getValue();
            upgrades.m_128405_(key, upgrades.m_128451_(key) + 1);
            wand.m_41784_().m_128365_(UPGRADES_KEY, (Tag)upgrades);
            return;
        }
    }

    public static int getProgression(ItemStack wand) {
        return wand.m_41784_().m_128451_(PROGRESSION_KEY);
    }

    public static void setProgression(ItemStack wand, int progression) {
        wand.m_41784_().m_128405_(PROGRESSION_KEY, progression);
    }

    public static void addProgression(ItemStack wand, int progression) {
        WandHelper.setProgression(wand, WandHelper.getProgression(wand) + progression);
    }

    public static int getDistributedCost(int cost, int castingTick) {
        int partialCost = castingTick % 20 == 0 ? cost / 2 + cost % 2 : (castingTick % 10 == 0 ? cost / 2 : 0);
        return partialCost;
    }

    public static SpellModifiers calculateModifiers(ItemStack stack, Player player, Spell spell) {
        SpellModifiers modifiers = new SpellModifiers();
        int level = WandHelper.getUpgradeLevel(stack, EBItems.RANGE_UPGRADE.get());
        if (level > 0) {
            modifiers.set(EBItems.RANGE_UPGRADE.get(), 1.0f + (float)level * EBConstants.RANGE_INCREASE_PER_LEVEL, true);
        }
        if ((level = WandHelper.getUpgradeLevel(stack, EBItems.DURATION_UPGRADE.get())) > 0) {
            modifiers.set(EBItems.DURATION_UPGRADE.get(), 1.0f + (float)level * EBConstants.DURATION_INCREASE_PER_LEVEL, false);
        }
        if ((level = WandHelper.getUpgradeLevel(stack, EBItems.BLAST_UPGRADE.get())) > 0) {
            modifiers.set(EBItems.BLAST_UPGRADE.get(), 1.0f + (float)level * EBConstants.BLAST_RADIUS_INCREASE_PER_LEVEL, true);
        }
        if ((level = WandHelper.getUpgradeLevel(stack, EBItems.COOLDOWN_UPGRADE.get())) > 0) {
            modifiers.set(EBItems.COOLDOWN_UPGRADE.get(), 1.0f - (float)level * EBConstants.COOLDOWN_REDUCTION_PER_LEVEL, true);
        }
        float progressionModifier = 1.0f - (float)Services.OBJECT_DATA.getWizardData(player).countRecentCasts(spell) / 5.0f * 0.75f;
        SpellManagerData data = Services.OBJECT_DATA.getSpellManagerData(player);
        WizardData wizardData = Services.OBJECT_DATA.getWizardData(player);
        Item item = stack.m_41720_();
        if (item instanceof IElementValue) {
            IElementValue elementValue = (IElementValue)item;
            item = stack.m_41720_();
            if (item instanceof ITierValue) {
                ITierValue tierValue = (ITierValue)item;
                if (elementValue.getElement() == spell.getElement()) {
                    modifiers.set("potency", 1.0f + (float)(tierValue.getTier((ItemStack)stack).level + 1) * EBConstants.POTENCY_INCREASE_PER_TIER, true);
                    progressionModifier *= 1.2f;
                }
                if (!wizardData.hasReachedTier(tierValue.getTier(stack).next())) {
                    progressionModifier *= 1.5f;
                }
            }
        }
        if (!data.hasSpellBeenDiscovered(spell)) {
            progressionModifier *= 5.0f;
        }
        modifiers.set(PROGRESSION_KEY, progressionModifier, false);
        return modifiers;
    }
}

