/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.api.content.util;

import com.binaris.wizardry.api.content.item.IManaStoringItem;
import com.binaris.wizardry.api.content.item.ITierValue;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellContext;
import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.api.content.util.SpellUtil;
import com.binaris.wizardry.api.content.util.WandHelper;
import com.binaris.wizardry.core.EBConfig;
import com.binaris.wizardry.setup.registries.SpellTiers;
import java.util.List;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class WorkbenchUtils {
    public static boolean rechargeManaFromCrystals(Slot centre, Slot crystals) {
        ItemStack stack = centre.m_7993_();
        Item item = stack.m_41720_();
        if (!(item instanceof IManaStoringItem)) {
            return false;
        }
        IManaStoringItem manaItem = (IManaStoringItem)item;
        if (!crystals.m_6657_() || manaItem.isManaFull(centre.m_7993_())) {
            return false;
        }
        int chargeDepleted = manaItem.getManaCapacity(centre.m_7993_()) - manaItem.getMana(centre.m_7993_());
        int manaPerItem = WorkbenchUtils.getManaValuePerCrystal(crystals.m_7993_());
        int totalAvailableMana = crystals.m_7993_().m_41613_() * manaPerItem;
        if (totalAvailableMana < chargeDepleted) {
            manaItem.rechargeMana(centre.m_7993_(), totalAvailableMana);
            crystals.m_6201_(crystals.m_7993_().m_41613_());
        } else {
            manaItem.setMana(centre.m_7993_(), manaItem.getManaCapacity(centre.m_7993_()));
            crystals.m_6201_((int)Math.ceil((double)chargeDepleted / (double)manaPerItem));
        }
        return true;
    }

    public static int getManaValuePerCrystal(ItemStack crystal) {
        Item item = crystal.m_41720_();
        if (item instanceof IManaStoringItem) {
            IManaStoringItem manaItem = (IManaStoringItem)item;
            return manaItem.getMana(crystal);
        }
        return 0;
    }

    public static boolean applySpellBooks(Slot centre, Slot[] spellBooks, SpellContext ctx) {
        SpellTier spellTier;
        List<Spell> spells = WandHelper.getSpells(centre.m_7993_());
        boolean changed = false;
        Item item = centre.m_7993_().m_41720_();
        if (item instanceof ITierValue) {
            ITierValue tierItem = (ITierValue)item;
            spellTier = tierItem.getTier(centre.m_7993_());
        } else {
            spellTier = SpellTiers.NOVICE;
        }
        SpellTier origin = spellTier;
        for (int i = 0; i < spells.size(); ++i) {
            Spell spell;
            if (!spellBooks[i].m_6657_() || !WorkbenchUtils.canBindSpell(spell = SpellUtil.getSpell(spellBooks[i].m_7993_()), spells, origin, i, ctx)) continue;
            WorkbenchUtils.updateSpellSlot(centre.m_7993_(), spells, i, spell);
            if (EBConfig.singleUseSpellBooks) {
                spellBooks[i].m_7993_().m_41774_(1);
            }
            changed = true;
        }
        if (changed) {
            WandHelper.setSpells(centre.m_7993_(), spells);
        }
        return changed;
    }

    public static boolean canBindSpell(Spell spell, List<Spell> spells, SpellTier origin, int slot, SpellContext ctx) {
        return spell.getTier().level <= origin.level && spells.get(slot) != spell && spell.isEnabled(ctx) && (!EBConfig.preventBindingSameSpellTwiceToWands || spells.stream().noneMatch(s -> s == spell));
    }

    public static void updateSpellSlot(ItemStack wand, List<Spell> spells, int slot, Spell spell) {
        int currentSelectedIndex = spells.indexOf(WandHelper.getCurrentSpell(wand));
        if (currentSelectedIndex == slot) {
            WandHelper.setCurrentSpell(wand, spell);
        }
        spells.set(slot, spell);
    }

    private WorkbenchUtils() {
    }
}

