/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.capabilities;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.content.data.ArcaneLockData;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.network.ArcaneLockSyncPacketS2C;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArcaneLockDataHolder
implements INBTSerializable<CompoundTag>,
ArcaneLockData {
    public static final ResourceLocation LOCATION = WizardryMainMod.location("arcane_lock_data");
    public static final Capability<ArcaneLockDataHolder> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<ArcaneLockDataHolder>(){});
    private final BlockEntity provider;
    private UUID ownerUUID = null;

    public ArcaneLockDataHolder(BlockEntity provider) {
        this.provider = provider;
    }

    private void sync() {
        if (this.provider.m_58904_() != null && !this.provider.m_58904_().m_5776_()) {
            CompoundTag tag = this.serializeNBT();
            ArcaneLockSyncPacketS2C packet = new ArcaneLockSyncPacketS2C(this.provider.m_58899_(), tag);
            Services.NETWORK_HELPER.sendToTracking((ServerLevel)this.provider.m_58904_(), this.provider.m_58899_(), packet);
        }
    }

    @Override
    public boolean isArcaneLocked() {
        return this.ownerUUID != null;
    }

    @Override
    public void setArcaneLockOwner(String ownerUUID) {
        this.ownerUUID = ownerUUID == null ? null : UUID.fromString(ownerUUID);
        this.sync();
    }

    @Override
    public void clearArcaneLockOwner() {
        this.ownerUUID = null;
        this.sync();
    }

    @Override
    @Nullable
    public UUID getArcaneLockOwnerUUID() {
        return this.ownerUUID;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.ownerUUID != null) {
            tag.m_128359_("arcaneLockOwner", this.ownerUUID.toString());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.ownerUUID = tag.m_128441_("arcaneLockOwner") ? UUID.fromString(tag.m_128461_("arcaneLockOwner")) : null;
    }

    public static class Provider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        private final LazyOptional<ArcaneLockDataHolder> holder = LazyOptional.of(() -> new ArcaneLockDataHolder(entity));

        public Provider(BlockEntity entity) {
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
            return INSTANCE.orEmpty(capability, this.holder.cast());
        }

        public CompoundTag serializeNBT() {
            return ((ArcaneLockDataHolder)this.holder.orElseThrow(NullPointerException::new)).serializeNBT();
        }

        public void deserializeNBT(CompoundTag arg) {
            ((ArcaneLockDataHolder)this.holder.orElseThrow(NullPointerException::new)).deserializeNBT(arg);
        }
    }
}

