/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.capabilities;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.content.data.CastCommandData;
import com.binaris.wizardry.api.content.event.SpellCastEvent;
import com.binaris.wizardry.api.content.spell.NoneSpell;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.internal.SpellModifiers;
import com.binaris.wizardry.core.event.WizardryEventBus;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.network.PlayerCapabilitySyncPacketS2C;
import com.binaris.wizardry.setup.registries.Spells;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CastCommandDataHolder
implements INBTSerializable<CompoundTag>,
CastCommandData {
    public static final ResourceLocation LOCATION = WizardryMainMod.location("cast_command_data");
    public static final Capability<CastCommandDataHolder> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<CastCommandDataHolder>(){});
    private final Player provider;
    private Spell castCommandSpell = Spells.NONE;
    private int castCommandTick;
    private SpellModifiers castCommandModifiers = new SpellModifiers();
    private int castCommandDuration;

    public CastCommandDataHolder(Player player) {
        this.provider = player;
    }

    public void sync() {
        if (!this.provider.m_9236_().m_5776_()) {
            CompoundTag tag = this.serializeNBT();
            PlayerCapabilitySyncPacketS2C packet = new PlayerCapabilitySyncPacketS2C(PlayerCapabilitySyncPacketS2C.CapabilityType.CAST_COMMAND, tag);
            Services.NETWORK_HELPER.sendTo((ServerPlayer)this.provider, packet);
        }
    }

    @Override
    public void startCastingContinuousSpell(Spell spell, SpellModifiers modifiers, int duration) {
        this.castCommandSpell = spell;
        this.castCommandModifiers = modifiers;
        this.castCommandDuration = duration;
        this.sync();
    }

    @Override
    public void stopCastingContinuousSpell() {
        this.castCommandSpell = Spells.NONE;
        this.castCommandTick = 0;
        this.castCommandModifiers.reset();
        this.sync();
    }

    @Override
    public void tick() {
        if (!this.isCommandCasting()) {
            return;
        }
        if (this.castCommandSpell == null || this.castCommandSpell instanceof NoneSpell || this.castCommandSpell.isInstantCast()) {
            this.castCommandTick = 0;
        }
        if (this.castCommandTick >= this.castCommandDuration) {
            this.stopCastingContinuousSpell();
            return;
        }
        if (WizardryEventBus.getInstance().fire(new SpellCastEvent.Tick(SpellCastEvent.Source.COMMAND, this.castCommandSpell, (LivingEntity)this.provider, this.castCommandModifiers, this.castCommandTick))) {
            this.stopCastingContinuousSpell();
            return;
        }
        if (this.castCommandSpell.cast(new PlayerCastContext(this.provider.m_9236_(), this.provider, InteractionHand.MAIN_HAND, this.castCommandTick, this.castCommandModifiers)) && this.castCommandTick == 0) {
            WizardryEventBus.getInstance().fire(new SpellCastEvent.Post(SpellCastEvent.Source.COMMAND, this.castCommandSpell, (LivingEntity)this.provider, this.castCommandModifiers));
        }
        ++this.castCommandTick;
        this.sync();
    }

    @Override
    public boolean isCommandCasting() {
        return this.castCommandSpell != null && this.castCommandSpell != Spells.NONE;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("castCommandSpell", (Tag)StringTag.m_129297_((String)this.castCommandSpell.getLocation().toString()));
        tag.m_128405_("castCommandDuration", this.castCommandDuration);
        tag.m_128405_("castCommandTick", this.castCommandTick);
        tag.m_128365_("castCommandModifiers", (Tag)this.castCommandModifiers.toTag());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        ResourceLocation spellLocation = ResourceLocation.m_135820_((String)tag.m_128461_("castCommandSpell"));
        Spell spell = Services.REGISTRY_UTIL.getSpell(spellLocation);
        this.castCommandSpell = spell != null ? spell : Spells.NONE;
        this.castCommandDuration = tag.m_128451_("castCommandDuration");
        this.castCommandTick = tag.m_128451_("castCommandTick");
        Tag modifiersTag = tag.m_128423_("castCommandModifiers");
        this.castCommandModifiers = modifiersTag instanceof CompoundTag ? SpellModifiers.fromTag((CompoundTag)modifiersTag) : new SpellModifiers();
    }

    public void copyFrom(@NotNull CastCommandDataHolder old) {
        this.castCommandSpell = old.castCommandSpell;
        this.castCommandTick = old.castCommandTick;
        this.castCommandModifiers = old.castCommandModifiers;
        this.castCommandDuration = old.castCommandDuration;
    }

    public static class Provider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        private final LazyOptional<CastCommandDataHolder> dataHolder = LazyOptional.of(() -> new CastCommandDataHolder(player));

        public Provider(Player player) {
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
            return INSTANCE.orEmpty(capability, this.dataHolder.cast());
        }

        public CompoundTag serializeNBT() {
            return ((CastCommandDataHolder)this.dataHolder.orElseThrow(NullPointerException::new)).serializeNBT();
        }

        public void deserializeNBT(CompoundTag arg) {
            ((CastCommandDataHolder)this.dataHolder.orElseThrow(NullPointerException::new)).deserializeNBT(arg);
        }
    }
}

