/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.capabilities;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.content.data.ContainmentData;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.network.ContainmentSyncPacketS2C;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainmentDataHolder
implements INBTSerializable<CompoundTag>,
ContainmentData {
    public static final ResourceLocation LOCATION = WizardryMainMod.location("containment_data");
    public static final Capability<ContainmentDataHolder> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<ContainmentDataHolder>(){});
    private final LivingEntity provider;
    private BlockPos containmentPos = null;

    public ContainmentDataHolder(LivingEntity entity) {
        this.provider = entity;
    }

    private void sync() {
        if (!this.provider.m_9236_().m_5776_()) {
            CompoundTag tag = this.serializeNBT();
            ContainmentSyncPacketS2C packet = new ContainmentSyncPacketS2C(this.provider.m_19879_(), tag);
            LivingEntity livingEntity = this.provider;
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                Services.NETWORK_HELPER.sendTo(serverPlayer, packet);
            } else {
                Services.NETWORK_HELPER.sendToTracking((Entity)this.provider, packet);
            }
        }
    }

    @Override
    public LivingEntity getProvider() {
        return this.provider;
    }

    @Override
    @Nullable
    public BlockPos getContainmentPos() {
        return this.containmentPos;
    }

    @Override
    public void setContainmentPos(@Nullable BlockPos pos) {
        this.containmentPos = pos;
        this.sync();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.containmentPos != null) {
            CompoundTag posTag = new CompoundTag();
            posTag.m_128405_("x", this.containmentPos.m_123341_());
            posTag.m_128405_("y", this.containmentPos.m_123342_());
            posTag.m_128405_("z", this.containmentPos.m_123343_());
            tag.m_128365_("containmentPos", (Tag)posTag);
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128441_("containmentPos")) {
            CompoundTag posTag = tag.m_128469_("containmentPos");
            int x = posTag.m_128451_("x");
            int y = posTag.m_128451_("y");
            int z = posTag.m_128451_("z");
            this.containmentPos = new BlockPos(x, y, z);
        } else {
            this.containmentPos = null;
        }
    }

    public static class Provider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        private final LazyOptional<ContainmentDataHolder> dataHolder = LazyOptional.of(() -> new ContainmentDataHolder(entity));

        public Provider(LivingEntity entity) {
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
            return INSTANCE.orEmpty(capability, this.dataHolder.cast());
        }

        public CompoundTag serializeNBT() {
            return ((ContainmentDataHolder)this.dataHolder.orElseThrow(NullPointerException::new)).serializeNBT();
        }

        public void deserializeNBT(CompoundTag arg) {
            ((ContainmentDataHolder)this.dataHolder.orElseThrow(NullPointerException::new)).deserializeNBT(arg);
        }
    }
}

