/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.capabilities;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.content.data.ImbuementEnchantData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ImbuementEnchantDataHolder
implements INBTSerializable<CompoundTag>,
ImbuementEnchantData {
    public static final ResourceLocation LOCATION = WizardryMainMod.location("imbuement_enchant");
    public static final Capability<ImbuementEnchantDataHolder> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<ImbuementEnchantDataHolder>(){});
    private CompoundTag tag = new CompoundTag();

    @Override
    public void addImbuement(Enchantment enchant, long expireTime) {
        ResourceLocation enchantKey = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchant);
        if (enchantKey == null) {
            return;
        }
        String enchantId = enchantKey.toString();
        if (!this.tag.m_128441_(enchantId)) {
            this.tag.m_128356_(enchantId, expireTime);
        }
    }

    @Override
    public Map<ResourceLocation, Long> getImbuements() {
        HashMap<ResourceLocation, Long> result = new HashMap<ResourceLocation, Long>();
        this.tag.m_128431_().forEach(key -> {
            try {
                ResourceLocation enchantId = ResourceLocation.m_135820_((String)key);
                long expireTime = this.tag.m_128454_(key);
                result.put(enchantId, expireTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return result;
    }

    @Override
    public void removeImbuement(Enchantment enchant) {
        ResourceLocation enchantKey = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchant);
        if (enchantKey == null) {
            return;
        }
        String enchantId = enchantKey.toString();
        if (this.tag.m_128441_(enchantId)) {
            this.tag.m_128473_(enchantId);
        }
    }

    @Override
    public boolean isImbuement(Enchantment enchant) {
        ResourceLocation enchantId = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchant);
        if (enchantId == null) {
            return false;
        }
        return this.tag.m_128441_(enchantId.toString());
    }

    @Override
    public long getExpirationTime(Enchantment enchantment) {
        ResourceLocation enchantId = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment);
        if (enchantId == null) {
            return -1L;
        }
        if (this.tag.m_128441_(enchantId.toString())) {
            return this.tag.m_128454_(enchantId.toString());
        }
        return -1L;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("imbuements", (Tag)this.tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.tag = tag.m_128441_("imbuements") ? tag.m_128469_("imbuements") : new CompoundTag();
    }

    public static class Provider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        private final LazyOptional<ImbuementEnchantDataHolder> dataHolder = LazyOptional.of(ImbuementEnchantDataHolder::new);

        public Provider(ItemStack stack) {
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, Direction arg) {
            return INSTANCE.orEmpty(capability, this.dataHolder.cast());
        }

        public CompoundTag serializeNBT() {
            return ((ImbuementEnchantDataHolder)this.dataHolder.orElseThrow(NullPointerException::new)).serializeNBT();
        }

        public void deserializeNBT(CompoundTag arg) {
            ((ImbuementEnchantDataHolder)this.dataHolder.orElseThrow(NullPointerException::new)).deserializeNBT(arg);
        }
    }
}

