/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.capabilities;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.data.MinionData;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.network.MinionSyncPacketS2C;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinionDataHolder
implements INBTSerializable<CompoundTag>,
MinionData {
    public static final ResourceLocation LOCATION = WizardryMainMod.location("minion_data");
    public static final Capability<MinionDataHolder> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<MinionDataHolder>(){});
    private final Mob provider;
    private int lifetime = -1;
    private boolean summoned = false;
    private boolean shouldDeleteGoals = false;
    private boolean shouldFollowOwner = false;
    @Nullable
    private UUID ownerUUID = null;
    private boolean shouldRestartGoals;

    public MinionDataHolder(Mob mob) {
        this.provider = mob;
    }

    private void sync() {
        if (!this.provider.m_9236_().m_5776_()) {
            CompoundTag tag = this.serializeNBT();
            MinionSyncPacketS2C packet = new MinionSyncPacketS2C(this.provider.m_19879_(), tag);
            Services.NETWORK_HELPER.sendToTracking((Entity)this.provider, packet);
        }
    }

    @Override
    public Mob getProvider() {
        return this.provider;
    }

    @Override
    public void tick() {
        if (!this.summoned) {
            return;
        }
        if (this.goalRestart()) {
            this.updateGoals();
            this.markGoalRestart(false);
        }
        if (this.provider.f_19797_ > this.getLifetime() && this.getLifetime() > 0) {
            this.provider.m_146870_();
        }
        if (this.provider.m_9236_().f_46443_ && this.provider.m_9236_().f_46441_.m_188503_(8) == 0) {
            ParticleBuilder.create(EBParticles.DARK_MAGIC).pos(this.provider.f_19854_, this.provider.f_19855_ + (this.provider.m_9236_().f_46441_.m_188500_() * 1.5 + 1.0), this.provider.f_19856_).color(0.1f, 0.0f, 0.0f).spawn(this.provider.m_9236_());
        }
        this.setLifetime(this.getLifetime() - 1);
        this.sync();
    }

    @Override
    public int getLifetime() {
        return this.lifetime;
    }

    @Override
    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    @Override
    public boolean isSummoned() {
        return this.summoned;
    }

    @Override
    public void setSummoned(boolean summoned) {
        this.summoned = summoned;
        this.sync();
    }

    @Override
    public boolean shouldDeleteGoals() {
        return this.shouldDeleteGoals;
    }

    @Override
    public void setShouldDeleteGoals(boolean shouldDeleteGoals) {
        this.shouldDeleteGoals = shouldDeleteGoals;
    }

    @Override
    public boolean shouldFollowOwner() {
        return this.shouldFollowOwner;
    }

    @Override
    public void setShouldFollowOwner(boolean shouldFollowOwner) {
        this.shouldFollowOwner = shouldFollowOwner;
    }

    @Override
    @Nullable
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public void setOwnerUUID(@Nullable UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
        this.sync();
    }

    @Override
    public Player getOwner() {
        return this.ownerUUID == null ? null : this.provider.m_9236_().m_46003_(this.ownerUUID);
    }

    @Override
    public void markGoalRestart(boolean shouldRestartGoals) {
        this.shouldRestartGoals = shouldRestartGoals;
    }

    @Override
    public boolean goalRestart() {
        return this.shouldRestartGoals;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("lifetime", this.lifetime);
        tag.m_128379_("summoned", this.summoned);
        tag.m_128379_("shouldDeleteGoals", this.shouldDeleteGoals);
        tag.m_128379_("shouldFollowOwner", this.shouldFollowOwner);
        if (this.ownerUUID != null) {
            tag.m_128362_("ownerUUID", this.ownerUUID);
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.lifetime = tag.m_128451_("lifetime");
        this.summoned = tag.m_128471_("summoned");
        this.shouldDeleteGoals = tag.m_128471_("shouldDeleteGoals");
        this.shouldFollowOwner = tag.m_128471_("shouldFollowOwner");
        if (tag.m_128441_("ownerUUID")) {
            this.ownerUUID = tag.m_128342_("ownerUUID");
        }
    }

    public static class Provider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        private final LazyOptional<MinionDataHolder> dataHolder = LazyOptional.of(() -> new MinionDataHolder(mob));

        public Provider(Mob mob) {
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
            return INSTANCE.orEmpty(capability, this.dataHolder.cast());
        }

        public CompoundTag serializeNBT() {
            return ((MinionDataHolder)this.dataHolder.orElseThrow(NullPointerException::new)).serializeNBT();
        }

        public void deserializeNBT(CompoundTag arg) {
            ((MinionDataHolder)this.dataHolder.orElseThrow(NullPointerException::new)).deserializeNBT(arg);
        }
    }
}

