/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.capabilities;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.content.data.ISpellVar;
import com.binaris.wizardry.api.content.data.IStoredSpellVar;
import com.binaris.wizardry.api.content.data.SpellManagerData;
import com.binaris.wizardry.api.content.spell.NoneSpell;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.network.PlayerCapabilitySyncPacketS2C;
import com.binaris.wizardry.setup.registries.Spells;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpellManagerDataHolder
implements INBTSerializable<CompoundTag>,
SpellManagerData {
    public static final ResourceLocation LOCATION = WizardryMainMod.location("spell_manager_data");
    public static final Capability<SpellManagerDataHolder> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<SpellManagerDataHolder>(){});
    public static final Set<IStoredSpellVar> storedVariables = new HashSet<IStoredSpellVar>();
    public final Map<ISpellVar, Object> spellData = new HashMap<ISpellVar, Object>();
    private final Player provider;
    public Set<Spell> spellsDiscovered = new HashSet<Spell>();

    public SpellManagerDataHolder(Player player) {
        this.provider = player;
        this.spellsDiscovered.add(Spells.NONE);
        this.spellsDiscovered.add(Spells.MAGIC_MISSILE);
    }

    @Override
    public void sync() {
        if (!this.provider.m_9236_().m_5776_()) {
            CompoundTag tag = this.serializeNBT();
            PlayerCapabilitySyncPacketS2C packet = new PlayerCapabilitySyncPacketS2C(PlayerCapabilitySyncPacketS2C.CapabilityType.SPELL_MANAGER, tag);
            Services.NETWORK_HELPER.sendTo((ServerPlayer)this.provider, packet);
        }
    }

    @Override
    public <T> T getVariable(ISpellVar<T> var) {
        return (T)this.spellData.get(var);
    }

    @Override
    public <T> void setVariable(ISpellVar<? super T> variable, T value) {
        this.spellData.put(variable, value);
    }

    @Override
    public Map<ISpellVar, Object> getSpellData() {
        return this.spellData;
    }

    @Override
    public boolean hasSpellBeenDiscovered(Spell spell) {
        return this.spellsDiscovered.contains(spell) || spell instanceof NoneSpell;
    }

    @Override
    public boolean discoverSpell(Spell spell) {
        if (spell instanceof NoneSpell) {
            return false;
        }
        boolean result = this.spellsDiscovered.add(spell);
        if (result) {
            this.sync();
        }
        return result;
    }

    @Override
    public boolean undiscoverSpell(Spell spell) {
        boolean result = this.spellsDiscovered.remove(spell);
        if (result) {
            this.sync();
        }
        return result;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag spellsDiscoveredTag = new ListTag();
        this.spellsDiscovered.forEach(spell -> spellsDiscoveredTag.add((Object)StringTag.m_129297_((String)spell.getLocation().toString())));
        tag.m_128365_("spellsDiscovered", (Tag)spellsDiscoveredTag);
        storedVariables.forEach(k -> k.write(tag, this.spellData.get(k)));
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.spellsDiscovered.clear();
        if (tag.m_128425_("spellsDiscovered", 9)) {
            ListTag listTag = tag.m_128437_("spellsDiscovered", 8);
            for (Tag element : listTag) {
                ResourceLocation location = ResourceLocation.m_135820_((String)element.m_7916_());
                if (location == null) continue;
                this.spellsDiscovered.add(Services.REGISTRY_UTIL.getSpell(location));
            }
        }
        try {
            storedVariables.forEach(k -> this.spellData.put((ISpellVar)k, k.read(tag)));
        }
        catch (ClassCastException e) {
            EBLogger.error("Wizard data NBT tag was not of expected type!", e);
        }
    }

    public void copyFrom(@NotNull SpellManagerDataHolder old) {
        this.spellsDiscovered.clear();
        this.spellsDiscovered.addAll(old.spellsDiscovered);
        this.spellData.clear();
        this.spellData.putAll(old.spellData);
    }

    public static class Provider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        private final LazyOptional<SpellManagerDataHolder> dataHolder = LazyOptional.of(() -> new SpellManagerDataHolder(player));

        public Provider(Player player) {
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
            return INSTANCE.orEmpty(capability, this.dataHolder.cast());
        }

        public CompoundTag serializeNBT() {
            return ((SpellManagerDataHolder)this.dataHolder.orElseThrow(NullPointerException::new)).serializeNBT();
        }

        public void deserializeNBT(CompoundTag arg) {
            ((SpellManagerDataHolder)this.dataHolder.orElseThrow(NullPointerException::new)).deserializeNBT(arg);
        }
    }
}

