/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.capabilities;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.content.data.WizardData;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.api.content.spell.internal.SpellModifiers;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.network.PlayerCapabilitySyncPacketS2C;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.google.common.collect.EvictingQueue;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WizardDataHolder
implements INBTSerializable<CompoundTag>,
WizardData {
    public static final ResourceLocation LOCATION = WizardryMainMod.location("wizard_data");
    public static final Capability<WizardDataHolder> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<WizardDataHolder>(){});
    public final Set<UUID> allies = new HashSet<UUID>();
    private final Player provider;
    public Set<String> allyNames = new HashSet<String>();
    public SpellModifiers itemModifiers = new SpellModifiers();
    private SpellTier maxTierReached = SpellTiers.NOVICE;
    private final Queue<AbstractMap.SimpleEntry<Spell, Long>> recentSpells = EvictingQueue.create((int)5);
    private Random random = new Random();

    public WizardDataHolder(Player player) {
        this.provider = player;
    }

    public void sync() {
        if (!this.provider.m_9236_().m_5776_()) {
            CompoundTag tag = this.serializeNBT();
            PlayerCapabilitySyncPacketS2C packet = new PlayerCapabilitySyncPacketS2C(PlayerCapabilitySyncPacketS2C.CapabilityType.WIZARD_DATA, tag);
            Services.NETWORK_HELPER.sendTo((ServerPlayer)this.provider, packet);
        }
    }

    @Override
    public void setTierReached(SpellTier tier) {
        if (!this.hasReachedTier(tier)) {
            this.maxTierReached = tier;
        }
        this.sync();
    }

    @Override
    public boolean hasReachedTier(SpellTier tier) {
        return tier.level >= this.maxTierReached.level;
    }

    @Override
    public boolean toggleAlly(Player friend) {
        if (this.isPlayerAlly(friend)) {
            this.allies.remove(friend.m_20148_());
            this.allyNames.remove(friend.m_5446_().getString());
            this.sync();
            return false;
        }
        this.allies.add(friend.m_20148_());
        this.allyNames.add(friend.m_5446_().getString());
        this.sync();
        return true;
    }

    @Override
    public boolean isPlayerAlly(Player ally) {
        return this.allies.contains(ally.m_20148_()) || this.provider != null && this.provider.m_5647_() != null && this.provider.m_5647_().m_6809_().contains(ally.m_5446_().getString());
    }

    @Override
    public boolean isPlayerAlly(UUID playerUUID) {
        if (this.allies.contains(playerUUID)) {
            return true;
        }
        if (this.provider == null || this.provider.m_5647_() == null) {
            return false;
        }
        return this.provider.m_5647_().m_6809_().stream().anyMatch(this.allyNames::contains);
    }

    @Override
    public SpellModifiers getSpellModifiers() {
        return this.itemModifiers;
    }

    @Override
    public void setSpellModifiers(SpellModifiers modifiers) {
        this.itemModifiers = modifiers;
        this.sync();
    }

    @Override
    public void trackRecentSpell(Spell spell, long timestamp) {
        this.recentSpells.add(new AbstractMap.SimpleEntry<Spell, Long>(spell, timestamp));
        this.sync();
    }

    @Override
    public int countRecentCasts(Spell spell) {
        return (int)this.recentSpells.stream().filter(entry -> ((Spell)entry.getKey()).equals(spell)).count();
    }

    @Override
    public void removeRecentCasts(Predicate<AbstractMap.SimpleEntry<Spell, Long>> predicate) {
        this.recentSpells.removeIf(predicate);
        this.sync();
    }

    @Override
    public Random getRandom() {
        return this.random;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("maxTier", this.maxTierReached.getOrCreateLocation().toString());
        ListTag alliesTag = new ListTag();
        this.allies.forEach(uuid -> alliesTag.add((Object)StringTag.m_129297_((String)uuid.toString())));
        tag.m_128365_("alliesUUID", (Tag)alliesTag);
        ListTag allyNamesTag = new ListTag();
        this.allyNames.forEach(name -> allyNamesTag.add((Object)StringTag.m_129297_((String)name)));
        tag.m_128365_("allyNames", (Tag)allyNamesTag);
        tag.m_128365_("itemModifiers", (Tag)this.itemModifiers.toTag());
        ListTag recentSpellsTag = new ListTag();
        for (AbstractMap.SimpleEntry simpleEntry : this.recentSpells) {
            CompoundTag spellEntryTag = new CompoundTag();
            spellEntryTag.m_128359_("spell", ((Spell)simpleEntry.getKey()).getLocation().toString());
            spellEntryTag.m_128356_("timestamp", ((Long)simpleEntry.getValue()).longValue());
            recentSpellsTag.add((Object)spellEntryTag);
        }
        tag.m_128365_("recentSpells", (Tag)recentSpellsTag);
        long seed = this.random.nextLong();
        tag.m_128356_("randomSeed", seed);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        SpellTier tier;
        ResourceLocation tierLocation = ResourceLocation.m_135820_((String)tag.m_128461_("maxTier"));
        if (tierLocation != null && (tier = Services.REGISTRY_UTIL.getTier(tierLocation)) != null) {
            this.maxTierReached = tier;
        }
        ListTag alliesTag = tag.m_128437_("alliesUUID", 8);
        this.allies.clear();
        for (int i = 0; i < alliesTag.size(); ++i) {
            String uuidString = alliesTag.m_128778_(i);
            try {
                UUID uuid = UUID.fromString(uuidString);
                this.allies.add(uuid);
                continue;
            }
            catch (IllegalArgumentException uuid) {
                // empty catch block
            }
        }
        ListTag allyNamesTag = tag.m_128437_("allyNames", 8);
        this.allyNames.clear();
        for (int i = 0; i < allyNamesTag.size(); ++i) {
            String name = allyNamesTag.m_128778_(i);
            this.allyNames.add(name);
        }
        if (tag.m_128441_("itemModifiers")) {
            this.itemModifiers = SpellModifiers.fromTag(tag.m_128469_("itemModifiers"));
        }
        ListTag recentSpellsTag = tag.m_128437_("recentSpells", 10);
        this.recentSpells.clear();
        for (int i = 0; i < recentSpellsTag.size(); ++i) {
            Spell spell;
            CompoundTag spellEntryTag = recentSpellsTag.m_128728_(i);
            ResourceLocation spellLocation = ResourceLocation.m_135820_((String)spellEntryTag.m_128461_("spell"));
            long timestamp = spellEntryTag.m_128454_("timestamp");
            if (spellLocation == null || (spell = Services.REGISTRY_UTIL.getSpell(spellLocation)) == null) continue;
            this.recentSpells.add(new AbstractMap.SimpleEntry<Spell, Long>(spell, timestamp));
        }
        if (tag.m_128441_("randomSeed")) {
            long seed = tag.m_128454_("randomSeed");
            this.random = new Random(seed);
        }
    }

    public void copyFrom(@NotNull WizardDataHolder holder) {
        this.allies.clear();
        this.allies.addAll(holder.allies);
        this.allyNames.clear();
        this.allyNames.addAll(holder.allyNames);
        this.itemModifiers = holder.itemModifiers;
        this.maxTierReached = holder.maxTierReached;
        this.recentSpells.clear();
        this.recentSpells.addAll(holder.recentSpells);
        this.random = holder.random;
    }

    public static class Provider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        private final LazyOptional<WizardDataHolder> dataHolder = LazyOptional.of(() -> new WizardDataHolder(player));

        public Provider(Player player) {
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
            return INSTANCE.orEmpty(capability, this.dataHolder.cast());
        }

        public CompoundTag serializeNBT() {
            return ((WizardDataHolder)this.dataHolder.orElseThrow(NullPointerException::new)).serializeNBT();
        }

        public void deserializeNBT(CompoundTag arg) {
            ((WizardDataHolder)this.dataHolder.orElseThrow(NullPointerException::new)).deserializeNBT(arg);
        }
    }
}

