/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client;

import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.client.particle.ParticleWizardry;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class ParticleSpawner {
    public static void spawnClientParticle(ParticleBuilder.ParticleData data) {
        ParticleWizardry particleWizardry;
        ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
        SimpleParticleType particle = (SimpleParticleType)BuiltInRegistries.f_257034_.m_7745_(data.particleType);
        BiFunction<ClientLevel, Vec3, ParticleWizardry> factory = ParticleWizardry.PROVIDERS.get(particle);
        ParticleWizardry particleWizardry2 = particleWizardry = factory == null ? null : factory.apply(clientLevel, new Vec3(data.x, data.y, data.z));
        if (particleWizardry == null) {
            EBLogger.error("Failed to spawn particle of type - {} - are you sure it exists?", data.particleType);
            return;
        }
        if (!(Double.isNaN(data.vx) || Double.isNaN(data.vy) || Double.isNaN(data.vz))) {
            particleWizardry.m_172260_(data.vx, data.vy, data.vz);
        }
        if (data.r >= 0.0f && data.g >= 0.0f && data.b >= 0.0f) {
            particleWizardry.m_107253_(data.r, data.g, data.b);
        }
        if (data.fr >= 0.0f && data.fg >= 0.0f && data.fb >= 0.0f) {
            particleWizardry.setFadeColour(data.fr, data.fg, data.fb);
        }
        if (data.lifetime >= 0) {
            particleWizardry.m_107257_(data.lifetime);
        }
        if (data.radius > 0.0) {
            particleWizardry.setSpin(data.radius, data.rpt);
        }
        if (!Float.isNaN(data.yaw) && !Float.isNaN(data.pitch)) {
            particleWizardry.setFacing(data.yaw, data.pitch);
        }
        if (data.seed != 0L) {
            particleWizardry.setSeed(data.seed);
        }
        if (!(Double.isNaN(data.tvx) || Double.isNaN(data.tvy) || Double.isNaN(data.tvz))) {
            particleWizardry.setTargetVelocity(data.tvx, data.tvy, data.tvz);
        }
        if (data.length > 0.0) {
            particleWizardry.setLength(data.length);
        }
        particleWizardry.m_6569_(data.scale);
        particleWizardry.setGravity(data.gravity);
        particleWizardry.setShaded(data.shaded);
        particleWizardry.setCollisions(data.collide);
        if (data.entityId != null) {
            Entity entity = clientLevel.m_6815_(data.entityId.intValue());
            if (entity == null) {
                EBLogger.error("Failed to set entity for particle of type - {} - entity ID {} not found", data.particleType, data.entityId);
            }
            particleWizardry.setEntity(entity);
        }
        particleWizardry.setTargetPosition(data.tx, data.ty, data.tz);
        if (data.targetId != null) {
            Entity target = clientLevel.m_6815_(data.targetId.intValue());
            particleWizardry.setTargetEntity(target);
        }
        Minecraft.m_91087_().f_91061_.m_107344_((Particle)particleWizardry);
    }
}

