/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.client.util.GlyphClientHandler;
import com.binaris.wizardry.api.content.event.EBLivingTick;
import com.binaris.wizardry.api.content.item.ISpellCastingItem;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.util.DrawingUtils;
import com.binaris.wizardry.client.SpellHUDSkin;
import com.binaris.wizardry.content.data.SpellGlyphData;
import com.binaris.wizardry.core.EBConfig;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class SpellGUIDisplay {
    public static final int CHARGE_METER_WIDTH = 25;
    public static final int CHARGE_METER_HEIGHT = 9;
    public static final int SPELL_ICON_SIZE = 32;
    public static final float SPELL_NAME_SCALE = 0.5f;
    public static final float SPELL_NAME_OPACITY = 0.3f;
    private static final ResourceLocation CHARGE_METER = WizardryMainMod.location("textures/gui/spell_charge_meter.png");
    private static final Map<String, SpellHUDSkin> SKINS = new LinkedHashMap<String, SpellHUDSkin>(14);
    private static final int SPELL_SWITCH_TIME = 4;
    private static final Minecraft mc = Minecraft.m_91087_();
    private static int switchTimer = 0;

    public static void init() {
        SpellGUIDisplay.addSkin("default", WizardryMainMod.location("gui/spell_hud/default.png"), WizardryMainMod.location("gui/spell_hud/default.json"));
    }

    public static void addSkin(String key, ResourceLocation texture, ResourceLocation metadata) {
        EBLogger.debug("Loading spell HUD skin: " + key, new Object[0]);
        SKINS.put(key, new SpellHUDSkin(texture, metadata));
    }

    @Nullable
    public static SpellHUDSkin getSkin(String key) {
        SpellHUDSkin skin = SKINS.get(key);
        if (skin == null) {
            EBLogger.info("The spell HUD skin specified in the config did not match any of the loaded skins; using the default skin as a fallback.", new Object[0]);
            skin = SKINS.get("default");
            if (skin == null) {
                EBLogger.warn("The default spell HUD skin is missing! A resource pack must have overridden it with an invalid JSON file (default.json), please try again without any resource packs.", new Object[0]);
                return null;
            }
        }
        return skin;
    }

    public static void draw(GuiGraphics guiGraphics, PoseStack stack, float partialTicks) {
        ISpellCastingItem castingItem;
        if (!EBConfig.showSpellHUD && !EBConfig.showChargeMeter) {
            return;
        }
        LocalPlayer player = SpellGUIDisplay.mc.f_91074_;
        if (player.m_5833_()) {
            return;
        }
        ItemStack wand = player.m_21205_();
        boolean mainHand = true;
        Item item = wand.m_41720_();
        if (!(item instanceof ISpellCastingItem) || !(castingItem = (ISpellCastingItem)item).showSpellHUD((Player)player, wand)) {
            ISpellCastingItem castingItem2;
            wand = player.m_21206_();
            mainHand = false;
            Item item2 = wand.m_41720_();
            if (!(item2 instanceof ISpellCastingItem) || !(castingItem2 = (ISpellCastingItem)item2).showSpellHUD((Player)player, wand)) {
                return;
            }
        }
        int width = mc.m_91268_().m_85445_();
        int height = mc.m_91268_().m_85446_();
        SpellGUIDisplay.renderChargeMeter(stack, (Player)player, wand, width, height, partialTicks);
        SpellGUIDisplay.renderSpellHUD(guiGraphics, stack, (Player)player, wand, mainHand, width, height, partialTicks, true);
        SpellGUIDisplay.renderSpellHUD(guiGraphics, stack, (Player)player, wand, mainHand, width, height, partialTicks, false);
    }

    public static void playSpellSwitchAnimation(boolean next) {
        switchTimer = next ? 4 : -4;
    }

    public static void renderSpellHUD(GuiGraphics guiGraphics, PoseStack stack, Player player, ItemStack wand, boolean mainHand, int width, int height, float partialTicks, boolean textLayer) {
        SpellHUDSkin skin;
        if (!EBConfig.showSpellHUD) {
            return;
        }
        if (!(wand.m_41720_() instanceof ISpellCastingItem)) {
            throw new IllegalArgumentException("The given stack must contain an ISpellCastingItem!");
        }
        boolean flipX = EBConfig.spellHUDFlipX;
        boolean flipY = EBConfig.spellHUDFlipY;
        if (EBConfig.spellHUDDynamicPositioning) {
            boolean bl = flipX = flipX == ((mainHand ? player.m_5737_() : player.m_5737_().m_20828_()) == HumanoidArm.LEFT);
        }
        if ((skin = SpellGUIDisplay.getSkin("default")) == null) {
            return;
        }
        stack.m_85836_();
        int x = flipX ? width : 0;
        int y = flipY ? 0 : height;
        Spell spell = ((ISpellCastingItem)wand.m_41720_()).getCurrentSpell(wand);
        int cooldown = ((ISpellCastingItem)wand.m_41720_()).getCurrentCooldown(wand, player.m_9236_());
        int maxCooldown = ((ISpellCastingItem)wand.m_41720_()).getCurrentMaxCooldown(wand);
        if (textLayer) {
            float animationProgress = Math.signum(switchTimer) * (((float)(4 - Math.abs(switchTimer)) + partialTicks) / 4.0f);
            Component prevSpellName = SpellGUIDisplay.getFormattedSpellName(((ISpellCastingItem)wand.m_41720_()).getPreviousSpell(wand), player, 0);
            Component spellName = SpellGUIDisplay.getFormattedSpellName(((ISpellCastingItem)wand.m_41720_()).getCurrentSpell(wand), player, cooldown);
            Component nextSpellName = SpellGUIDisplay.getFormattedSpellName(((ISpellCastingItem)wand.m_41720_()).getNextSpell(wand), player, 0);
            skin.drawText(guiGraphics, x, y, flipX, flipY, prevSpellName, spellName, nextSpellName, animationProgress);
        } else {
            boolean discovered = true;
            if (!player.m_7500_()) {
                discovered = Services.OBJECT_DATA.getSpellManagerData(player).hasSpellBeenDiscovered(spell);
            }
            ResourceLocation icon = discovered ? WizardryMainMod.location("textures/spells/%s.png".formatted(spell.getLocation().m_135815_())) : WizardryMainMod.location("textures/spells/none.png");
            float progress = 1.0f;
            if (!player.m_7500_()) {
                progress = maxCooldown == 0 ? 1.0f : ((float)maxCooldown - (float)cooldown + partialTicks) / (float)maxCooldown;
            }
            skin.drawBackground(stack, x, y, flipX, flipY, icon, progress, player.m_7500_(), player.m_21023_(EBMobEffects.ARCANE_JAMMER.get()));
        }
        stack.m_85849_();
    }

    public static void renderChargeMeter(PoseStack stack, Player player, ItemStack wand, int width, int height, float partialTicks) {
        if (player.m_5833_()) {
            return;
        }
        stack.m_85836_();
        if (!EBConfig.showChargeMeter) {
            return;
        }
        if (SpellGUIDisplay.mc.f_91066_.f_92063_) {
            return;
        }
        if (SpellGUIDisplay.mc.f_91066_.m_92176_() != CameraType.FIRST_PERSON) {
            return;
        }
        if (wand != player.m_21211_()) {
            return;
        }
        if (!(wand.m_41720_() instanceof ISpellCastingItem)) {
            throw new IllegalArgumentException("The given stack must contain an ISpellCastingItem!");
        }
        Spell spell = ((ISpellCastingItem)wand.m_41720_()).getCurrentSpell(wand);
        int chargeup = spell.getCharge();
        if ((chargeup = (int)((float)chargeup * Services.OBJECT_DATA.getWizardData(player).getSpellModifiers().get("chargeup"))) <= 0) {
            return;
        }
        if (player.m_21252_() == 0) {
            return;
        }
        float charge = ((float)player.m_21252_() + partialTicks) / (float)chargeup;
        if (charge > 1.0f) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CHARGE_METER);
        int x1 = width / 2 - 12 - 1;
        float y = (float)height / 2.0f - 4.5f - 0.5f;
        int w = (int)(12.5f * charge);
        int u = 25 - w;
        DrawingUtils.drawTexturedRect(x1, y, 0, 0, w, 9, 32, 32);
        DrawingUtils.drawTexturedRect(x1 + u, y, u, 0, w, 9, 32, 32);
        stack.m_85849_();
    }

    private static Component getFormattedSpellName(Spell spell, Player player, int cooldown) {
        Style format;
        boolean discovered = true;
        if (!player.m_7500_()) {
            discovered = Services.OBJECT_DATA.getSpellManagerData(player).hasSpellBeenDiscovered(spell);
        }
        Style style = format = cooldown > 0 ? Style.f_131099_.m_131140_(ChatFormatting.GRAY) : Style.f_131099_.m_131140_(spell.getElement().getColor());
        if (!discovered) {
            format = Style.f_131099_.m_131140_(ChatFormatting.BLUE).m_131150_(new ResourceLocation("minecraft", "alt"));
        }
        if (player.m_21023_(EBMobEffects.ARCANE_JAMMER.get())) {
            format = Style.f_131099_.m_178524_(Boolean.valueOf(true));
        }
        MutableComponent name = discovered ? Component.m_237115_((String)spell.getDescriptionId()) : Component.m_237113_((String)SpellGlyphData.getGlyphName(spell, GlyphClientHandler.INSTANCE.getGlyphData()));
        name.m_130948_(format);
        return name;
    }

    public static void onLivingTickEvent(EBLivingTick event) {
        if (event.getLevel().f_46443_ && event.getEntity() == SpellGUIDisplay.mc.f_91074_) {
            if (switchTimer > 0) {
                --switchTimer;
            } else if (switchTimer < 0) {
                ++switchTimer;
            }
        }
    }
}

