/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client;

import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.content.util.DrawingUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.GsonHelper;

public class SpellHUDSkin {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final Gson gson = new Gson();
    private static final Random random = new Random();
    private final ResourceLocation texture;
    private String name;
    private String description;
    private int width;
    private int height;
    private boolean mirrorX;
    private boolean mirrorY;
    private int spellIconInsetX;
    private int spellIconInsetY;
    private int textInsetX;
    private int textInsetY;
    private int cascadeOffsetX;
    private int cascadeOffsetY;
    private int cooldownBarX;
    private int cooldownBarY;
    private int cooldownBarLength;
    private int cooldownBarHeight;
    private boolean cooldownBarMirrorX;
    private boolean cooldownBarMirrorY;
    private boolean showCooldownWhenFull;

    public SpellHUDSkin(ResourceLocation texture, ResourceLocation metadata) {
        this.texture = texture;
        try {
            Resource metadataFile = mc.m_91098_().m_215593_(metadata);
            BufferedReader reader = new BufferedReader(new InputStreamReader(metadataFile.m_215507_(), StandardCharsets.UTF_8));
            JsonElement je = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
            this.parseJson(je.getAsJsonObject());
        }
        catch (IOException e) {
            EBLogger.error("Error reading spell HUD skin metadata file: ", e);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private void parseJson(JsonObject json) {
        this.name = GsonHelper.m_13906_((JsonObject)json, (String)"name");
        this.description = GsonHelper.m_13906_((JsonObject)json, (String)"description");
        this.width = GsonHelper.m_13927_((JsonObject)json, (String)"width");
        this.height = GsonHelper.m_13927_((JsonObject)json, (String)"height");
        JsonObject mirror = GsonHelper.m_13930_((JsonObject)json, (String)"mirror");
        this.mirrorX = GsonHelper.m_13912_((JsonObject)mirror, (String)"x");
        this.mirrorY = GsonHelper.m_13912_((JsonObject)mirror, (String)"y");
        JsonObject spellIconInset = GsonHelper.m_13930_((JsonObject)json, (String)"spell_icon_inset");
        this.spellIconInsetX = GsonHelper.m_13927_((JsonObject)spellIconInset, (String)"x");
        this.spellIconInsetY = GsonHelper.m_13927_((JsonObject)spellIconInset, (String)"y");
        JsonObject textInset = GsonHelper.m_13930_((JsonObject)json, (String)"text_inset");
        this.textInsetX = GsonHelper.m_13927_((JsonObject)textInset, (String)"x");
        this.textInsetY = GsonHelper.m_13927_((JsonObject)textInset, (String)"y");
        JsonObject cascadeOffset = GsonHelper.m_13930_((JsonObject)json, (String)"spell_cascade_offset");
        this.cascadeOffsetX = GsonHelper.m_13927_((JsonObject)cascadeOffset, (String)"x");
        this.cascadeOffsetY = GsonHelper.m_13927_((JsonObject)cascadeOffset, (String)"y");
        JsonObject cooldownBar = GsonHelper.m_13930_((JsonObject)json, (String)"cooldown_bar");
        this.cooldownBarX = GsonHelper.m_13927_((JsonObject)cooldownBar, (String)"x");
        this.cooldownBarY = GsonHelper.m_13927_((JsonObject)cooldownBar, (String)"y");
        this.cooldownBarLength = GsonHelper.m_13927_((JsonObject)cooldownBar, (String)"length");
        this.cooldownBarHeight = GsonHelper.m_13927_((JsonObject)cooldownBar, (String)"height");
        JsonObject cooldownBarMirror = GsonHelper.m_13930_((JsonObject)cooldownBar, (String)"mirror");
        this.cooldownBarMirrorX = GsonHelper.m_13912_((JsonObject)cooldownBarMirror, (String)"x");
        this.cooldownBarMirrorY = GsonHelper.m_13912_((JsonObject)cooldownBarMirror, (String)"y");
        this.showCooldownWhenFull = GsonHelper.m_13912_((JsonObject)cooldownBar, (String)"show_when_full");
    }

    public void drawBackground(PoseStack stack, int x, int y, boolean flipX, boolean flipY, ResourceLocation icon, float cooldownBarProgress, boolean creativeMode, boolean jammed) {
        int y1;
        if (flipX && !this.mirrorX) {
            x -= this.width;
        }
        if (flipY && !this.mirrorY) {
            y += this.height;
        }
        stack.m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)icon);
        int x1 = flipX && this.mirrorX ? x - this.spellIconInsetX - 32 : x + this.spellIconInsetX;
        int n = y1 = flipY && this.mirrorY ? y + this.spellIconInsetY : y - this.spellIconInsetY - 32;
        if (jammed) {
            random.setSeed(SpellHUDSkin.mc.f_91073_.m_46467_() / 2L);
            DrawingUtils.drawGlitchRect(random, x1, y1, 0, 0, 32, 32, 32, 32, false, false);
        } else {
            DrawingUtils.drawTexturedRect(x1, y1, 0, 0, 32, 32, 32, 32);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        x1 = flipX && this.mirrorX ? x - this.width : x;
        int n2 = y1 = flipY && this.mirrorY ? y : y - this.height;
        if (jammed) {
            DrawingUtils.drawGlitchRect(random, x1, y1, creativeMode ? 128 : 0, 0, this.width, this.height, 256, 256, flipX && this.mirrorX, flipY && this.mirrorY);
        } else {
            DrawingUtils.drawTexturedFlippedRect(x1, y1, creativeMode ? 128 : 0, 0, this.width, this.height, 256, 256, flipX && this.mirrorX, flipY && this.mirrorY);
        }
        if (!creativeMode && cooldownBarProgress > 0.0f && (this.showCooldownWhenFull || cooldownBarProgress < 1.0f)) {
            int l = (int)(cooldownBarProgress * (float)this.cooldownBarLength);
            x1 = flipX && this.mirrorX ? x - this.cooldownBarX - (this.cooldownBarMirrorX ? l : this.cooldownBarLength) : x + this.cooldownBarX;
            y1 = flipY && this.mirrorY ? y + this.cooldownBarY : y - this.cooldownBarY - this.cooldownBarHeight;
            int u = this.cooldownBarX;
            int v = this.height;
            if (jammed) {
                DrawingUtils.drawGlitchRect(random, x1, y1, u, v, l, this.cooldownBarHeight, 256, 256, flipX && this.cooldownBarMirrorX, flipY && this.cooldownBarMirrorY);
            } else {
                DrawingUtils.drawTexturedFlippedRect(x1, y1, u, v, l, this.cooldownBarHeight, 256, 256, flipX && this.cooldownBarMirrorX, flipY && this.cooldownBarMirrorY);
            }
        }
        stack.m_85849_();
    }

    public void drawText(GuiGraphics guiGraphics, int x, int y, boolean flipX, boolean flipY, Component prevSpellName, Component spellName, Component nextSpellName, float animationProgress) {
        int n;
        int x1;
        if (flipX && !this.mirrorX) {
            x -= this.width;
        }
        if (flipY && !this.mirrorY) {
            y += this.height;
        }
        Font font = SpellHUDSkin.mc.f_91062_;
        int n2 = x1 = flipX && this.mirrorX ? x - this.width : x + this.textInsetX;
        if (flipY && this.mirrorY) {
            Objects.requireNonNull(font);
            n = y + this.textInsetY - 9 / 2 + 2;
        } else {
            Objects.requireNonNull(font);
            n = y - this.textInsetY - 9 / 2 - 1;
        }
        int y1 = n;
        int maxWidth = this.width - this.textInsetX;
        if (animationProgress == 0.0f) {
            float xPrev;
            float f = flipX && this.mirrorX ? (float)(x - this.width) : (xPrev = (float)(x + this.textInsetX - (flipY ? -1 : 1) * this.cascadeOffsetX));
            float xNext = flipX && this.mirrorX ? (float)(x - this.width) : (float)(x + this.textInsetX + (flipY ? -1 : 1) * this.cascadeOffsetX);
            float yPrev = y1 - (this.cascadeOffsetY + 1);
            float yNext = y1 + this.cascadeOffsetY;
            float maxWidthPrev = maxWidth + (flipY ? -1 : 1) * this.cascadeOffsetX;
            float maxWidthNext = maxWidth - (flipY ? -1 : 1) * this.cascadeOffsetX;
            int sideColour = DrawingUtils.makeTranslucent(0xFFFFFF, 0.3f);
            DrawingUtils.drawScaledStringToWidth(guiGraphics, font, prevSpellName, xPrev, yPrev, 0.5f, sideColour, maxWidthPrev, true, flipX && this.mirrorX);
            DrawingUtils.drawScaledStringToWidth(guiGraphics, font, spellName, x1, y1, 1.0f, -1, maxWidth, true, flipX && this.mirrorX);
            DrawingUtils.drawScaledStringToWidth(guiGraphics, font, nextSpellName, xNext, yNext, 0.5f, sideColour, maxWidthNext, true, flipX && this.mirrorX);
        } else {
            float xPrev;
            boolean reverse;
            boolean bl = reverse = animationProgress < 0.0f;
            if (reverse) {
                animationProgress = 1.0f - Math.abs(animationProgress);
            }
            float f = flipX && this.mirrorX ? (float)(x - this.width) : (xPrev = (float)(x + this.textInsetX) - (float)((flipY ? -1 : 1) * this.cascadeOffsetX) * animationProgress);
            float xNext = flipX && this.mirrorX ? (float)(x - this.width) : (float)(x + this.textInsetX) + (float)((flipY ? -1 : 1) * this.cascadeOffsetX) * (1.0f - animationProgress);
            float yPrev = (float)y1 - (float)(this.cascadeOffsetY + 1) * animationProgress;
            float yNext = (float)y1 + (float)this.cascadeOffsetY * (1.0f - animationProgress);
            float maxWidthPrev = (float)maxWidth + (float)((flipY ? -1 : 1) * this.cascadeOffsetX) * animationProgress;
            float maxWidthNext = (float)maxWidth - (float)((flipY ? -1 : 1) * this.cascadeOffsetX) * (1.0f - animationProgress);
            float scalePrev = 0.5f + 0.5f * (1.0f - animationProgress);
            float scaleNext = 0.5f + 0.5f * animationProgress;
            int clrPrev = DrawingUtils.makeTranslucent(0xFFFFFF, (int)(0.3f + 0.7f * (1.0f - animationProgress)));
            int clrNext = DrawingUtils.makeTranslucent(0xFFFFFF, (int)(0.3f + 0.7f * animationProgress));
            if (reverse) {
                DrawingUtils.drawScaledStringToWidth(guiGraphics, font, spellName, xPrev, yPrev, scalePrev, clrPrev, maxWidthPrev, true, flipX && this.mirrorX);
                DrawingUtils.drawScaledStringToWidth(guiGraphics, font, nextSpellName, xNext, yNext, scaleNext, clrNext, maxWidthNext, true, flipX && this.mirrorX);
            } else {
                DrawingUtils.drawScaledStringToWidth(guiGraphics, font, prevSpellName, xPrev, yPrev, scalePrev, clrPrev, maxWidthPrev, true, flipX && this.mirrorX);
                DrawingUtils.drawScaledStringToWidth(guiGraphics, font, spellName, xNext, yNext, scaleNext, clrNext, maxWidthNext, true, flipX && this.mirrorX);
            }
        }
    }
}

