/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.effect;

import com.binaris.wizardry.api.content.data.ArcaneLockData;
import com.binaris.wizardry.api.content.util.GeometryUtil;
import com.binaris.wizardry.core.platform.Services;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public final class ArcaneLockRender {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[8];
    private static final int RENDER_DISTANCE_CHUNKS = 8;
    private static final int MAX_RENDER_DISTANCE_SQ = 4096;

    private ArcaneLockRender() {
    }

    public static void render(Camera camera, PoseStack poseStack, float partialTicks) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        Vec3 origin = player.m_20299_(partialTicks);
        Vec3 cameraPos = camera.m_90583_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        boolean renderStarted = false;
        ChunkPos playerChunkPos = new ChunkPos(BlockPos.m_274446_((Position)origin));
        for (int chunkX = playerChunkPos.f_45578_ - 8; chunkX <= playerChunkPos.f_45578_ + 8; ++chunkX) {
            for (int chunkZ = playerChunkPos.f_45579_ - 8; chunkZ <= playerChunkPos.f_45579_ + 8; ++chunkZ) {
                if (!world.m_7232_(chunkX, chunkZ)) continue;
                LevelChunk chunk = world.m_6325_(chunkX, chunkZ);
                for (BlockEntity blockEntity : chunk.m_62954_().values()) {
                    ArcaneLockData data;
                    if (!(blockEntity instanceof BaseContainerBlockEntity)) continue;
                    BaseContainerBlockEntity containerBlock = (BaseContainerBlockEntity)blockEntity;
                    BlockPos pos = blockEntity.m_58899_();
                    double distSq = pos.m_203198_(origin.f_82479_, origin.f_82480_, origin.f_82481_);
                    if (distSq > 4096.0 || (data = Services.OBJECT_DATA.getArcaneLockData((BlockEntity)containerBlock)) == null || !data.isArcaneLocked()) continue;
                    if (!renderStarted) {
                        renderStarted = true;
                        poseStack.m_85836_();
                        RenderSystem.enableBlend();
                        RenderSystem.defaultBlendFunc();
                        RenderSystem.disableCull();
                        RenderSystem.depthMask((boolean)false);
                        RenderSystem.setShader(GameRenderer::m_172817_);
                        int textureIndex = player.f_19797_ % (TEXTURES.length * 2) / 2;
                        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURES[textureIndex]);
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
                        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                    }
                    AABB boundingBox = world.m_8055_(pos).m_60808_((BlockGetter)world, pos).m_83215_().m_82400_(0.05).m_82338_(pos);
                    Vec3[] vertices = GeometryUtil.getVertices(boundingBox);
                    Matrix4f matrix = poseStack.m_85850_().m_252922_();
                    ArcaneLockRender.drawFace(buffer, matrix, vertices[0], vertices[1], vertices[3], vertices[2], 0.0f, 0.0f, 1.0f, 1.0f);
                    ArcaneLockRender.drawFace(buffer, matrix, vertices[6], vertices[7], vertices[2], vertices[3], 0.0f, 0.0f, 1.0f, 1.0f);
                    ArcaneLockRender.drawFace(buffer, matrix, vertices[5], vertices[6], vertices[1], vertices[2], 0.0f, 0.0f, 1.0f, 1.0f);
                    ArcaneLockRender.drawFace(buffer, matrix, vertices[4], vertices[5], vertices[0], vertices[1], 0.0f, 0.0f, 1.0f, 1.0f);
                    ArcaneLockRender.drawFace(buffer, matrix, vertices[7], vertices[4], vertices[3], vertices[0], 0.0f, 0.0f, 1.0f, 1.0f);
                    ArcaneLockRender.drawFace(buffer, matrix, vertices[5], vertices[4], vertices[6], vertices[7], 0.0f, 0.0f, 1.0f, 1.0f);
                }
            }
        }
        if (renderStarted) {
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85849_();
        }
    }

    private static void drawFace(BufferBuilder buffer, Matrix4f matrix, Vec3 topLeft, Vec3 topRight, Vec3 bottomLeft, Vec3 bottomRight, float u1, float v1, float u2, float v2) {
        buffer.m_252986_(matrix, (float)topLeft.f_82479_, (float)topLeft.f_82480_, (float)topLeft.f_82481_).m_7421_(u1, v1).m_5752_();
        buffer.m_252986_(matrix, (float)topRight.f_82479_, (float)topRight.f_82480_, (float)topRight.f_82481_).m_7421_(u2, v1).m_5752_();
        buffer.m_252986_(matrix, (float)bottomRight.f_82479_, (float)bottomRight.f_82480_, (float)bottomRight.f_82481_).m_7421_(u2, v2).m_5752_();
        buffer.m_252986_(matrix, (float)bottomLeft.f_82479_, (float)bottomLeft.f_82480_, (float)bottomLeft.f_82481_).m_7421_(u1, v2).m_5752_();
    }

    static {
        for (int i = 0; i < TEXTURES.length; ++i) {
            ArcaneLockRender.TEXTURES[i] = new ResourceLocation("ebwizardry", "textures/block/arcane_lock_" + i + ".png");
        }
    }
}

