/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.effect;

import com.binaris.wizardry.api.content.data.ContainmentData;
import com.binaris.wizardry.api.content.util.GeometryUtil;
import com.binaris.wizardry.content.effect.ContainmentEffect;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public final class ContainmentFieldRender {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[8];
    private static final float ANIMATION_SPEED = 0.004f;
    private static final float FADE_DISTANCE_SQUARED = 15.0f;

    private ContainmentFieldRender() {
    }

    public static void render(Camera camera, PoseStack poseStack, float partialTicks) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || !player.m_6084_()) {
            return;
        }
        MobEffectInstance effect = player.m_21124_(EBMobEffects.CONTAINMENT.get());
        if (effect == null) {
            return;
        }
        ContainmentData data = Services.OBJECT_DATA.getContainmentData((LivingEntity)player);
        if (data.getContainmentPos() == null) {
            return;
        }
        Vec3 centre = GeometryUtil.getCentre(data.getContainmentPos());
        float r = ContainmentEffect.getContainmentDistance(effect.m_19564_());
        Vec3 cameraPos = camera.m_90583_();
        poseStack.m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableCull();
        int textureIndex = player.f_19797_ % (TEXTURES.length * 2) / 2;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURES[textureIndex]);
        RenderSystem.texParameter((int)3553, (int)10242, (int)10497);
        RenderSystem.texParameter((int)3553, (int)10243, (int)10497);
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float distance = ((float)player.f_19797_ + partialTicks) * 0.004f;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        Vec3 playerEyes = player.m_20299_(partialTicks);
        Vec3 relative = centre.m_82546_(playerEyes);
        relative = relative.m_82546_(cameraPos.m_82546_(playerEyes));
        double x1 = relative.f_82479_ - (double)r;
        double y1 = relative.f_82480_ - (double)r;
        double z1 = relative.f_82481_ - (double)r;
        double x2 = relative.f_82479_ + (double)r;
        double y2 = relative.f_82480_ + (double)r;
        double z2 = relative.f_82481_ + (double)r;
        float alpha = Math.min(1.0f, (float)effect.m_19557_() / 40.0f);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, y1, z1, 0.0f, 0.0f, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, y1, 0.0, 0.0f, -((float)z1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, y1, 0.0, -((float)x1), -((float)z1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, y1, z1, -((float)x1), 0.0f, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, y1, 0.0, -((float)x1), -((float)z1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, y1, 0.0, 2.0f * r, -((float)z1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, y1, z1, 2.0f * r, 0.0f, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, y1, z1, -((float)x1), 0.0f, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, y1, z2, 0.0f, 2.0f * r, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, y1, z2, -((float)x1), 2.0f * r, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, y1, 0.0, -((float)x1), -((float)z1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, y1, 0.0, 0.0f, -((float)z1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, y1, 0.0, -((float)x1), -((float)z1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, y1, z2, -((float)x1), 2.0f * r, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, y1, z2, 2.0f * r, 2.0f * r, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, y1, 0.0, 2.0f * r, -((float)z1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, y2, z1, 0.0f, 0.0f, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, y2, z1, -((float)x1), 0.0f, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, y2, 0.0, -((float)x1), -((float)z1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, y2, 0.0, 0.0f, -((float)z1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, y2, z1, 2.0f * r, 0.0f, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, y2, 0.0, 2.0f * r, -((float)z1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, y2, 0.0, -((float)x1), -((float)z1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, y2, z1, -((float)x1), 0.0f, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, y2, 0.0, -((float)x1), -((float)z1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, y2, z2, -((float)x1), 2.0f * r, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, y2, z2, 0.0f, 2.0f * r, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, y2, 0.0, 0.0f, -((float)z1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, y2, 0.0, -((float)x1), -((float)z1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, y2, 0.0, 2.0f * r, -((float)z1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, y2, z2, 2.0f * r, 2.0f * r, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, y2, z2, -((float)x1), 2.0f * r, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, y1, z1, 0.0f, 0.0f, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, y1, z1, -((float)x1), 0.0f, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, 0.0, z1, -((float)x1), -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, 0.0, z1, 0.0f, -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, y1, z1, 2.0f * r, 0.0f, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, 0.0, z1, 2.0f * r, -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, 0.0, z1, -((float)x1), -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, y1, z1, -((float)x1), 0.0f, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, 0.0, z1, -((float)x1), -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, y2, z1, -((float)x1), 2.0f * r, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, y2, z1, 0.0f, 2.0f * r, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, 0.0, z1, 0.0f, -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, 0.0, z1, -((float)x1), -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, 0.0, z1, 2.0f * r, -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, y2, z1, 2.0f * r, 2.0f * r, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, y2, z1, -((float)x1), 2.0f * r, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, y1, z2, 0.0f, 0.0f, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, 0.0, z2, 0.0f, -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, 0.0, z2, -((float)x1), -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, y1, z2, -((float)x1), 0.0f, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, 0.0, z2, -((float)x1), -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, 0.0, z2, 2.0f * r, -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, y1, z2, 2.0f * r, 0.0f, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, y1, z2, -((float)x1), 0.0f, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, y2, z2, 0.0f, 2.0f * r, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, y2, z2, -((float)x1), 2.0f * r, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, 0.0, z2, -((float)x1), -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, 0.0, z2, 0.0f, -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, 0.0, z2, -((float)x1), -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, 0.0, y2, z2, -((float)x1), 2.0f * r, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, y2, z2, 2.0f * r, 2.0f * r, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, 0.0, z2, 2.0f * r, -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, y1, z1, 0.0f, 0.0f, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, 0.0, z1, 0.0f, -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, 0.0, 0.0, -((float)z1), -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, y1, 0.0, -((float)z1), 0.0f, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, 0.0, 0.0, -((float)z1), -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, 0.0, z2, 2.0f * r, -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, y1, z2, 2.0f * r, 0.0f, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, y1, 0.0, -((float)z1), 0.0f, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, y2, z1, 0.0f, 2.0f * r, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, y2, 0.0, -((float)z1), 2.0f * r, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, 0.0, 0.0, -((float)z1), -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, 0.0, z1, 0.0f, -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, 0.0, 0.0, -((float)z1), -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, y2, 0.0, -((float)z1), 2.0f * r, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, y2, z2, 2.0f * r, 2.0f * r, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x1, 0.0, z2, 2.0f * r, -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, y1, z1, 0.0f, 0.0f, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, y1, 0.0, -((float)z1), 0.0f, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, 0.0, 0.0, -((float)z1), -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, 0.0, z1, 0.0f, -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, y1, z2, 2.0f * r, 0.0f, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, 0.0, z2, 2.0f * r, -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, 0.0, 0.0, -((float)z1), -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, y1, 0.0, -((float)z1), 0.0f, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, 0.0, 0.0, -((float)z1), -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, y2, 0.0, -((float)z1), 2.0f * r, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, y2, z1, 0.0f, 2.0f * r, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, 0.0, z1, 0.0f, -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, 0.0, 0.0, -((float)z1), -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, 0.0, z2, 2.0f * r, -((float)y1), distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, y2, z2, 2.0f * r, 2.0f * r, distance, alpha);
        ContainmentFieldRender.drawVertex(buffer, matrix, x2, y2, 0.0, -((float)z1), 2.0f * r, distance, alpha);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    private static void drawVertex(BufferBuilder buffer, Matrix4f matrix, double x, double y, double z, float u, float v, float offset, float alpha) {
        float distSq = (float)(x * x + y * y + z * z);
        float fade = Mth.m_14036_((float)(1.0f - distSq / 15.0f), (float)0.0f, (float)1.0f);
        buffer.m_252986_(matrix, (float)x, (float)y, (float)z).m_7421_(u + offset, v + offset).m_85950_(1.0f, 1.0f, 1.0f, fade * alpha).m_5752_();
    }

    static {
        for (int i = 0; i < TEXTURES.length; ++i) {
            ContainmentFieldRender.TEXTURES[i] = new ResourceLocation("ebwizardry", "textures/environment/containment_field_" + i + ".png");
        }
    }
}

