/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.gui.elements;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;

public abstract class TooltipElement {
    public final int spaceAfter;
    private final TooltipElement[] children;

    public TooltipElement(int spaceAfter, TooltipElement ... children) {
        this.children = children;
        this.spaceAfter = spaceAfter;
    }

    public int getTotalHeight(ItemStack stack) {
        if (!this.isVisible(stack)) {
            return 0;
        }
        int height = this.getHeight(stack);
        for (TooltipElement child : this.children) {
            height += child.getTotalHeight(stack);
        }
        return height + this.spaceAfter;
    }

    public int drawBackgroundLayer(GuiGraphics guiGraphics, int x, int y, ItemStack stack, float partialTicks, int mouseX, int mouseY) {
        if (!this.isVisible(stack)) {
            return y;
        }
        this.drawBackground(guiGraphics, x, y, stack, partialTicks, mouseX, mouseY);
        y += this.getHeight(stack);
        for (TooltipElement child : this.children) {
            y = child.drawBackgroundLayer(guiGraphics, x, y, stack, partialTicks, mouseX, mouseY);
        }
        return y + this.spaceAfter;
    }

    public int drawForegroundLayer(GuiGraphics guiGraphics, int x, int y, ItemStack stack, int mouseX, int mouseY) {
        if (!this.isVisible(stack)) {
            return y;
        }
        this.drawForeground(guiGraphics, x, y, stack, mouseX, mouseY);
        y += this.getHeight(stack);
        for (TooltipElement child : this.children) {
            y = child.drawForegroundLayer(guiGraphics, x, y, stack, mouseX, mouseY);
        }
        return y + this.spaceAfter;
    }

    protected abstract boolean isVisible(ItemStack var1);

    protected abstract int getHeight(ItemStack var1);

    protected abstract void drawBackground(GuiGraphics var1, int var2, int var3, ItemStack var4, float var5, int var6, int var7);

    protected abstract void drawForeground(GuiGraphics var1, int var2, int var3, ItemStack var4, int var5, int var6);
}

