/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.gui.elements;

import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.api.content.util.DrawingUtils;
import com.binaris.wizardry.api.content.util.WandHelper;
import com.binaris.wizardry.client.gui.elements.TooltipElement;
import com.binaris.wizardry.content.item.WandItem;
import com.binaris.wizardry.setup.registries.SpellTiers;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class TooltipElementProgressionBar
extends TooltipElement {
    private final int height;

    public TooltipElementProgressionBar(int height, int spaceAfter) {
        super(spaceAfter, new TooltipElement[0]);
        this.height = height;
    }

    @Override
    protected boolean isVisible(ItemStack stack) {
        return stack.m_41720_() instanceof WandItem;
    }

    @Override
    protected int getHeight(ItemStack stack) {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        return 9 + 1 + 3;
    }

    @Override
    protected void drawBackground(GuiGraphics guiGraphics, int x, int y, ItemStack stack, float partialTicks, int mouseX, int mouseY) {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        y += 9 + 1;
        float progressFraction = 1.0f;
        SpellTier nextTier = this.getNextTier(stack);
        if (nextTier != null) {
            progressFraction = (float)WandHelper.getProgression(stack) / (float)nextTier.getProgression();
        }
        DrawingUtils.drawTexturedRect(x, y, 176, this.height + 3, 131, 3, 512, 512);
        int width = (int)(131.0f * progressFraction);
        DrawingUtils.drawTexturedRect(x, y, 176, this.height, width, 3, 512, 512);
    }

    @Override
    protected void drawForeground(GuiGraphics guiGraphics, int x, int y, ItemStack stack, int mouseX, int mouseY) {
        SpellTier tier = ((WandItem)stack.m_41720_()).getTier(stack);
        guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, tier.getDescriptionFormatted().getString(), x, y, tier.getDescriptionFormatted().m_7383_().m_131135_().m_131265_(), true);
        SpellTier nextTier = this.getNextTier(stack);
        if (nextTier != null) {
            MutableComponent s = nextTier.getDescriptionFormatted().m_6881_().m_130940_(ChatFormatting.DARK_GRAY);
            if (WandHelper.getProgression(stack) >= nextTier.getProgression()) {
                s = nextTier.getDescriptionFormatted();
            }
            guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, s.getString(), x + 144 - 12 - Minecraft.m_91087_().f_91062_.m_92895_(s.getString()), y, s.m_7383_().m_131135_().m_131265_(), true);
        }
    }

    @Nullable
    private SpellTier getNextTier(ItemStack stack) {
        SpellTier tier = ((WandItem)stack.m_41720_()).getTier(stack);
        if (tier != SpellTiers.MASTER) {
            return SpellTiers.getNextByLevel(tier.level + 1);
        }
        return null;
    }
}

