/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.gui.elements;

import com.binaris.wizardry.api.client.util.ClientUtils;
import com.binaris.wizardry.api.client.util.GlyphClientHandler;
import com.binaris.wizardry.api.content.item.ISpellCastingItem;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.util.DrawingUtils;
import com.binaris.wizardry.api.content.util.SpellUtil;
import com.binaris.wizardry.client.gui.elements.TooltipElement;
import com.binaris.wizardry.client.gui.elements.TooltipElementText;
import com.binaris.wizardry.client.gui.screens.ArcaneWorkbenchScreen;
import com.binaris.wizardry.content.data.SpellGlyphData;
import com.binaris.wizardry.content.item.ScrollItem;
import com.binaris.wizardry.content.item.SpellBookItem;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.Spells;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class TooltipElementSpellEntry
extends TooltipElementText {
    private final int index;
    private final ArcaneWorkbenchScreen screen;

    public TooltipElementSpellEntry(ArcaneWorkbenchScreen screen, int index) {
        super(null, Style.f_131099_.m_131140_(ChatFormatting.BLUE), 1, new TooltipElement[0]);
        this.index = index;
        this.screen = screen;
    }

    private boolean shouldFlash(ItemStack stack) {
        ItemStack spellBook = this.screen.getMenu().m_38853_(this.index).m_7993_();
        return !spellBook.m_41619_() && (spellBook.m_41720_() instanceof SpellBookItem || spellBook.m_41720_() instanceof ScrollItem) && SpellUtil.getSpell(stack) != ((ISpellCastingItem)stack.m_41720_()).getSpells(stack)[this.index];
    }

    private float getAlpha(float partialTicks) {
        return (Mth.m_14031_((float)(0.2f * ((float)Minecraft.m_91087_().f_91074_.f_19797_ + partialTicks))) + 1.0f) / 4.0f + 0.5f;
    }

    @Override
    protected boolean isVisible(ItemStack stack) {
        return stack.m_41720_() instanceof ISpellCastingItem && this.index < ((ISpellCastingItem)stack.m_41720_()).getSpells(stack).length;
    }

    @Override
    protected int getColour(ItemStack stack) {
        Spell spell = this.getSpell(stack);
        boolean discovered = ClientUtils.shouldDisplayDiscovered(spell, stack);
        int color = discovered ? spell.getElement().getColor().m_126665_() : ChatFormatting.BLUE.m_126665_();
        return this.shouldFlash(stack) ? DrawingUtils.makeTranslucent(color, this.getAlpha(Minecraft.m_91087_().m_91296_())) : color;
    }

    @Override
    protected Component getText(ItemStack stack) {
        Spell spell = this.getSpell(stack);
        if (spell == null) {
            return Component.m_237119_();
        }
        if (ClientUtils.shouldDisplayDiscovered(spell, null)) {
            return Component.m_237115_((String)spell.getDescriptionId().toString()).m_130940_(spell.getElement().getColor());
        }
        return Component.m_237113_((String)SpellGlyphData.getGlyphName(spell, GlyphClientHandler.INSTANCE.getGlyphData())).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.BLUE).m_131150_(new ResourceLocation("minecraft", "alt")));
    }

    @Override
    protected void drawBackground(GuiGraphics guiGraphics, int x, int y, ItemStack stack, float partialTicks, int mouseX, int mouseY) {
        Spell spell = this.getSpell(stack);
        RenderSystem._setShaderTexture((int)0, (ResourceLocation)(ClientUtils.shouldDisplayDiscovered(spell, null) ? spell.getElement().getIconId() : Elements.MAGIC.getIconId()));
        if (this.shouldFlash(stack)) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.getAlpha(partialTicks));
        }
        DrawingUtils.drawTexturedRect(x, y, 8, 8);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private Spell getSpell(ItemStack stack) {
        ItemStack spellBook = this.screen.getMenu().m_38853_(this.index).m_7993_();
        if (!spellBook.m_41619_() && (spellBook.m_41720_() instanceof SpellBookItem || spellBook.m_41720_() instanceof ScrollItem)) {
            return SpellUtil.getSpell(spellBook);
        }
        Spell spell = ((ISpellCastingItem)stack.m_41720_()).getSpells(stack)[this.index];
        return spell == null ? Spells.NONE : spell;
    }

    @Override
    protected void drawForeground(GuiGraphics guiGraphics, int x, int y, ItemStack stack, int mouseX, int mouseY) {
        x += 11;
        int color = this.getColour(stack);
        if (color == 0) {
            this.getText(stack).m_7383_().m_131135_();
        }
        guiGraphics.m_280430_(this.getFontRenderer(stack), this.getText(stack), x, y, color);
    }
}

