/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.gui.elements;

import com.binaris.wizardry.api.content.item.IManaStoringItem;
import com.binaris.wizardry.client.gui.elements.TooltipElement;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class TooltipElementText
extends TooltipElement {
    private final String text;
    private final Style style;

    public TooltipElementText(String text, Style style, int spaceAfter, TooltipElement ... children) {
        super(spaceAfter, children);
        this.text = text;
        this.style = style;
    }

    @Override
    protected int getHeight(ItemStack stack) {
        int n = this.getFontRenderer(stack).m_92923_((FormattedText)this.getText(stack), 132).size();
        Objects.requireNonNull(this.getFontRenderer(stack));
        return n * 9;
    }

    @Override
    protected void drawBackground(GuiGraphics guiGraphics, int x, int y, ItemStack stack, float partialTicks, int mouseX, int mouseY) {
    }

    @Override
    protected void drawForeground(GuiGraphics guiGraphics, int x, int y, ItemStack stack, int mouseX, int mouseY) {
        int color = this.getColour(stack);
        if (color == 0) {
            this.getText(stack).m_7383_().m_131135_();
        }
        guiGraphics.m_280056_(this.getFontRenderer(stack), this.getText(stack).getString(), x, y, color, true);
    }

    protected Component getText(ItemStack stack) {
        return Component.m_237113_((String)this.text).m_130948_(this.style);
    }

    protected Font getFontRenderer(ItemStack stack) {
        return Minecraft.m_91087_().f_91062_;
    }

    protected int getColour(ItemStack stack) {
        return ChatFormatting.WHITE.m_126665_();
    }

    protected Style getStyle() {
        return this.style;
    }

    @Override
    protected boolean isVisible(ItemStack stack) {
        return true;
    }

    public static class TooltipElementManaReadout
    extends TooltipElementText {
        public TooltipElementManaReadout(int spaceAfter) {
            super(null, Style.f_131099_.m_131140_(ChatFormatting.BLUE), spaceAfter, new TooltipElement[0]);
        }

        @Override
        protected Component getText(ItemStack stack) {
            IManaStoringItem manaItem = (IManaStoringItem)stack.m_41720_();
            return Component.m_237113_((String)I18n.m_118938_((String)"container.ebwizardry.arcane_workbench.mana", (Object[])new Object[]{manaItem.getMana(stack), manaItem.getManaCapacity(stack)})).m_130948_(this.getStyle());
        }

        @Override
        protected int getColour(ItemStack stack) {
            TextColor color = this.getStyle().m_131135_();
            return color == null ? super.getColour(stack) : color.m_131265_();
        }

        @Override
        protected boolean isVisible(ItemStack stack) {
            return stack.m_41720_() instanceof IManaStoringItem && ((IManaStoringItem)stack.m_41720_()).showManaInWorkbench((Player)Minecraft.m_91087_().f_91074_, stack);
        }
    }

    public static class TooltipElementItemName
    extends TooltipElementText {
        public TooltipElementItemName(Style style, int spaceAfter) {
            super(null, style, spaceAfter, new TooltipElement[0]);
        }

        @Override
        protected Component getText(ItemStack stack) {
            return stack.m_41720_().m_7626_(stack);
        }

        @Override
        protected int getColour(ItemStack stack) {
            TextColor textColor = stack.m_41720_().m_7626_(stack).m_7383_().m_131135_();
            return textColor == null ? super.getColour(stack) : textColor.m_131265_();
        }
    }
}

