/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.gui.elements;

import com.binaris.wizardry.api.content.util.WandHelper;
import com.binaris.wizardry.client.gui.elements.TooltipElement;
import com.binaris.wizardry.client.gui.screens.ArcaneWorkbenchScreen;
import com.binaris.wizardry.setup.registries.WandUpgrades;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

class TooltipElementUpgrades
extends TooltipElement {
    private static final int ITEM_SIZE = 16;
    private static final int ITEM_SPACING = 2;
    public final ArcaneWorkbenchScreen screen;

    public TooltipElementUpgrades(ArcaneWorkbenchScreen screen, int spaceAfter) {
        super(spaceAfter, new TooltipElement[0]);
        this.screen = screen;
    }

    @Override
    protected boolean isVisible(ItemStack stack) {
        return true;
    }

    @Override
    protected int getHeight(ItemStack stack) {
        int rows = 1 + (WandHelper.getTotalUpgrades(stack) * 18 - 2) / 132;
        return rows * 18 - 2;
    }

    @Override
    protected void drawBackground(GuiGraphics guiGraphics, int x, int y, ItemStack stack, float partialTicks, int mouseX, int mouseY) {
        int x1 = 0;
        for (Item item : WandUpgrades.getSpecialUpgrades()) {
            int upgradeLevel = WandHelper.getUpgradeLevel(stack, item);
            if (upgradeLevel <= 0) continue;
            ItemStack upgrade = new ItemStack((ItemLike)item, upgradeLevel);
            guiGraphics.m_280203_(upgrade, x + x1, y);
            guiGraphics.m_280370_(Minecraft.m_91087_().f_91062_, upgrade, x + x1, y);
            if ((x1 += 18) + 16 <= 132) continue;
            x1 = 0;
            y += 18;
        }
    }

    @Override
    protected void drawForeground(GuiGraphics guiGraphics, int x, int y, ItemStack stack, int mouseX, int mouseY) {
        boolean x1 = false;
        for (Item item : WandUpgrades.getSpecialUpgrades()) {
            int level = WandHelper.getUpgradeLevel(stack, item);
            if (level >= 0) continue;
        }
    }
}

