/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.gui.screens;

import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.content.item.IWorkbenchItem;
import com.binaris.wizardry.api.content.util.DrawingUtils;
import com.binaris.wizardry.client.EBClientConstants;
import com.binaris.wizardry.client.gui.button.GuiButtonApply;
import com.binaris.wizardry.client.gui.button.GuiButtonClear;
import com.binaris.wizardry.client.gui.elements.TooltipElement;
import com.binaris.wizardry.client.gui.elements.TooltipElementProgressionBar;
import com.binaris.wizardry.client.gui.elements.TooltipElementSpellEntry;
import com.binaris.wizardry.client.gui.elements.TooltipElementSpellList;
import com.binaris.wizardry.client.gui.elements.TooltipElementText;
import com.binaris.wizardry.client.gui.elements.TooltipElementUpgradeList;
import com.binaris.wizardry.content.menu.ArcaneWorkbenchMenu;
import com.binaris.wizardry.core.networking.c2s.ControlInputPacketC2S;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ArcaneWorkbenchScreen
extends AbstractContainerScreen<ArcaneWorkbenchMenu> {
    private final Inventory playerInventory;
    private final ArcaneWorkbenchMenu menu;
    private final List<TooltipElement> tooltipElements = new ArrayList<TooltipElement>();
    private AbstractWidget applyBtn;
    private AbstractWidget clearBtn;
    private int animationTimer = 0;

    public ArcaneWorkbenchScreen(ArcaneWorkbenchMenu menu, Inventory playerInventory, Component name) {
        super((AbstractContainerMenu)menu, playerInventory, name);
        this.menu = menu;
        this.playerInventory = playerInventory;
        this.f_97726_ = 176;
        this.f_97727_ = 220;
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.f_96541_ == null) {
            return;
        }
        if (this.f_96541_.f_91074_ == null) {
            return;
        }
        this.f_96541_.f_91074_.f_36096_ = this.menu;
        this.f_97735_ = (this.f_96543_ - 176) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        this.m_169413_();
        this.applyBtn = new GuiButtonApply(0, this.f_96543_ / 2 + 64, this.f_96544_ / 2 + 3, button -> {
            if (button.f_93623_) {
                ControlInputPacketC2S packet = new ControlInputPacketC2S(ControlInputPacketC2S.ControlType.APPLY_BUTTON);
                Services.NETWORK_HELPER.sendToServer(packet);
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)EBSounds.BLOCK_ARCANE_WORKBENCH_SPELLBIND.get(), (float)1.0f));
                this.animationTimer = 20;
            }
        });
        this.m_142416_((GuiEventListener)this.applyBtn);
        this.clearBtn = new GuiButtonClear(0, this.f_96543_ / 2 + 64, this.f_96544_ / 2 - 16, button -> {
            if (button.f_93623_) {
                ControlInputPacketC2S packet = new ControlInputPacketC2S(ControlInputPacketC2S.ControlType.CLEAR_BUTTON);
                Services.NETWORK_HELPER.sendToServer(packet);
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)EBSounds.BLOCK_ARCANE_WORKBENCH_SPELLBIND.get(), (float)0.8f));
                this.animationTimer = 20;
            }
        });
        this.m_142416_((GuiEventListener)this.clearBtn);
        this.tooltipElements.clear();
        this.tooltipElements.add(new TooltipElementText.TooltipElementItemName(Style.f_131099_.m_131140_(ChatFormatting.WHITE), 5));
        this.tooltipElements.add(new TooltipElementText.TooltipElementManaReadout(5));
        this.tooltipElements.add(new TooltipElementProgressionBar(this.f_97727_, 5));
        this.tooltipElements.add(new TooltipElementSpellList(5, this.generateSpellEntries()));
        this.tooltipElements.add(new TooltipElementUpgradeList(this, 5));
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Slot centreSlot = this.menu.m_38853_(9);
        this.f_97726_ = 176;
        this.f_97735_ = (this.f_96543_ - 176) / 2;
        if (centreSlot.m_6657_() && centreSlot.m_7993_().m_41720_() instanceof IWorkbenchItem && ((IWorkbenchItem)centreSlot.m_7993_().m_41720_()).showTooltip(centreSlot.m_7993_())) {
            this.f_97726_ += 144;
        }
        this.applyBtn.f_93623_ = centreSlot.m_6657_();
        this.clearBtn.f_93623_ = centreSlot.m_6657_() && centreSlot.m_7993_().m_41720_() instanceof IWorkbenchItem && ((IWorkbenchItem)centreSlot.m_7993_().m_41720_()).isClearable();
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_7286_(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)EBClientConstants.ARCANE_WORKBENCH_CONTAINER_TEXTURE);
        int left = this.f_97735_;
        int top = this.f_97736_;
        DrawingUtils.drawTexturedRect(left + 38, top + 22, 320, 0, 100, 100, 512, 512);
        if (this.animationTimer > 0) {
            guiGraphics.m_280168_().m_85836_();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            int x = left + 38 + 50;
            int y = top + 22 + 50;
            float scale = ((float)this.animationTimer + partialTick) / 20.0f;
            scale = (float)(1.0 - Math.pow(1.0f - scale, 1.4f));
            guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
            guiGraphics.m_280168_().m_252880_((float)x / scale, (float)y / scale, 0.0f);
            DrawingUtils.drawTexturedRectF(guiGraphics.m_280168_(), -78.0f, -78.0f, 320.0f, 100.0f, 156.0f, 156.0f, 512.0f, 512.0f);
            RenderSystem.disableBlend();
            guiGraphics.m_280168_().m_85849_();
        }
        DrawingUtils.drawTexturedRect(left, top, 0, 0, 176, this.f_97727_, 512, 512);
        float opacity = ((float)this.animationTimer + partialTick) / 20.0f;
        for (int i = 0; i < 8; ++i) {
            Slot slot = this.menu.m_38853_(i);
            if (slot.f_40220_ < 0 || slot.f_40221_ < 0) continue;
            DrawingUtils.drawTexturedRect(this.f_97735_ + slot.f_40220_ - 10, this.f_97736_ + slot.f_40221_ - 10, 0, 220, 36, 36, 512, 512);
            if (this.animationTimer <= 0 || !slot.m_6657_()) continue;
            guiGraphics.m_280168_().m_85836_();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
            DrawingUtils.drawTexturedRect(this.f_97735_ + slot.f_40220_ - 10, this.f_97736_ + slot.f_40221_ - 10, 36, 220, 36, 36, 512, 512);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            guiGraphics.m_280168_().m_85849_();
        }
        if (this.animationTimer > 0) {
            Slot crystals = this.menu.m_38853_(8);
            Slot upgrades = this.menu.m_38853_(10);
            if (crystals.m_6657_()) {
                guiGraphics.m_280168_().m_85836_();
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
                DrawingUtils.drawTexturedRect(this.f_97735_ + crystals.f_40220_ - 8, this.f_97736_ + crystals.f_40221_ - 8, 420, 0, 32, 32, 512, 512);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                guiGraphics.m_280168_().m_85849_();
            }
            if (upgrades.m_6657_()) {
                guiGraphics.m_280168_().m_85836_();
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
                DrawingUtils.drawTexturedRect(this.f_97735_ + upgrades.f_40220_ - 8, this.f_97736_ + upgrades.f_40221_ - 8, 420, 0, 32, 32, 512, 512);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                guiGraphics.m_280168_().m_85849_();
            }
        }
        if (this.menu.m_38853_(9).m_6657_()) {
            ItemStack stack = this.menu.m_38853_(9).m_7993_();
            if (!(stack.m_41720_() instanceof IWorkbenchItem)) {
                EBLogger.warn("Invalid item in central slot of arcane workbench, how did that get there?!", new Object[0]);
                return;
            }
            if (((IWorkbenchItem)stack.m_41720_()).showTooltip(stack)) {
                int tooltipHeight = this.tooltipElements.stream().mapToInt(e -> e.getTotalHeight(stack)).sum() - this.tooltipElements.get((int)(this.tooltipElements.size() - 1)).spaceAfter;
                DrawingUtils.drawTexturedRect(left + 176, top, 176, 0, 144, 6 + tooltipHeight, 512, 512);
                DrawingUtils.drawTexturedRect(left + 176, top + 6 + tooltipHeight, 176, this.f_97727_ - 6, 144, 6, 512, 512);
                int x = left + 176 + 6;
                int y = top + 6;
                for (TooltipElement element : this.tooltipElements) {
                    y = element.drawBackgroundLayer(guiGraphics, x, y, stack, partialTick, mouseX, mouseY);
                }
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)EBClientConstants.ARCANE_WORKBENCH_CONTAINER_TEXTURE);
        RenderSystem.disableBlend();
    }

    protected void m_280003_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int left = 0;
        guiGraphics.m_280614_(this.f_96547_, this.m_96636_(), left + 8, 6, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, this.playerInventory.m_7755_().getString(), left + 8, this.f_97727_ - 96 + 2, 0x404040, false);
        if (this.menu.m_38853_(9).m_6657_()) {
            ItemStack stack = this.menu.m_38853_(9).m_7993_();
            if (!(stack.m_41720_() instanceof IWorkbenchItem)) {
                EBLogger.warn("Invalid item in central slot of arcane workbench, how did that get there?!", new Object[0]);
                return;
            }
            if (((IWorkbenchItem)stack.m_41720_()).showTooltip(stack)) {
                int x = left + 176 + 6;
                int y = 6;
                for (TooltipElement element : this.tooltipElements) {
                    y = element.drawForegroundLayer(guiGraphics, x, y, stack, mouseX, mouseY);
                }
            }
        }
    }

    protected void m_181908_() {
        if (this.animationTimer > 0) {
            --this.animationTimer;
        }
        if (this.menu.needsRefresh) {
            this.menu.needsRefresh = false;
        }
    }

    private TooltipElement[] generateSpellEntries() {
        TooltipElement[] entries = new TooltipElement[8];
        for (int i = 0; i < 8; ++i) {
            entries[i] = new TooltipElementSpellEntry(this, i);
        }
        return entries;
    }

    @NotNull
    public ArcaneWorkbenchMenu getMenu() {
        return this.menu;
    }
}

