/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.gui.screens.abstr;

import com.binaris.wizardry.api.client.util.ClientUtils;
import com.binaris.wizardry.api.client.util.GlyphClientHandler;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.util.DrawingUtils;
import com.binaris.wizardry.content.data.SpellGlyphData;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.Spells;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.NotNull;

public abstract class SpellInfoScreen
extends Screen {
    protected static final String TRANSLATION_KEY_PREFIX = "gui.ebwizardry.spell_book";
    protected final int xSize;
    protected final int ySize;
    protected int textureWidth = 512;
    protected int textureHeight = 256;

    protected SpellInfoScreen(int xSize, int ySize, Component component) {
        super(component);
        this.xSize = xSize;
        this.ySize = ySize;
    }

    protected void setTextureSize(int width, int height) {
        this.textureWidth = width;
        this.textureHeight = height;
    }

    public abstract Spell getSpell();

    public abstract ResourceLocation getTexture();

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int left = this.f_96543_ / 2 - this.xSize / 2;
        int top = this.f_96544_ / 2 - this.ySize / 2;
        this.m_280273_(guiGraphics);
        this.drawBackgroundLayer(left, top, mouseX, mouseY);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.drawForegroundLayer(guiGraphics, left, top, mouseX, mouseY);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    protected void drawBackgroundLayer(int left, int top, int mouseX, int mouseY) {
        boolean discovered = ClientUtils.shouldDisplayDiscovered(this.getSpell(), null);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)(discovered ? this.getSpell().getIcon() : Spells.NONE.getIcon()));
        DrawingUtils.drawTexturedRect(left + 146, top + 20, 0, 0, 128, 128, 128, 128);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getTexture());
        DrawingUtils.drawTexturedRect(left, top, 0, 0, this.xSize, this.ySize, this.textureWidth, this.textureHeight);
    }

    protected void drawForegroundLayer(GuiGraphics guiGraphics, int left, int top, int mouseX, int mouseY) {
        boolean discovered = ClientUtils.shouldDisplayDiscovered(this.getSpell(), null);
        Font font = discovered ? this.f_96541_.f_91062_ : this.f_96541_.f_243022_;
        MutableComponent spellName = discovered ? ((MutableComponent)this.getSpell().getDescriptionFormatted()).m_130940_(ChatFormatting.BLACK) : Component.m_237113_((String)SpellGlyphData.getGlyphName(this.getSpell(), GlyphClientHandler.INSTANCE.getGlyphData())).m_130948_(Style.f_131099_.m_131150_(new ResourceLocation("minecraft", "alt")));
        guiGraphics.m_280614_(font, (Component)spellName, left + 17, top + 15, 0, false);
        guiGraphics.m_280614_(font, (Component)Component.m_237115_((String)this.getSpell().getType().getDisplayName()), left + 17, top + 26, 0x777777, false);
        ChatFormatting tierColor = this.getSpell().getTier() == SpellTiers.NOVICE ? ChatFormatting.GRAY : this.getSpell().getTier().getColor();
        MutableComponent tier = Component.m_237110_((String)"gui.ebwizardry.spell_book.tier", (Object[])new Object[]{((MutableComponent)this.getSpell().getTier().getDescriptionFormatted()).m_130940_(tierColor)});
        guiGraphics.m_280614_(this.f_96547_, (Component)tier, left + 17, top + 45, 0, false);
        ChatFormatting elementColor = this.getSpell().getElement() == Elements.HEALING ? ChatFormatting.GOLD : this.getSpell().getElement().getColor();
        MutableComponent element = Component.m_237110_((String)"gui.ebwizardry.spell_book.element", (Object[])new Object[]{((MutableComponent)this.getSpell().getElement().getDescriptionFormatted()).m_130940_(elementColor)});
        if (!discovered) {
            element = Component.m_237115_((String)"gui.ebwizardry.spell_book.element_undiscovered");
        }
        guiGraphics.m_280614_(this.f_96547_, (Component)element, left + 17, top + 57, 0, false);
        String manaCost = I18n.m_118938_((String)"gui.ebwizardry.spell_book.mana_cost", (Object[])new Object[]{this.getSpell().getCost()});
        if (!this.getSpell().isInstantCast()) {
            manaCost = I18n.m_118938_((String)"gui.ebwizardry.spell_book.mana_cost_continuous", (Object[])new Object[]{this.getSpell().getCost()});
        }
        if (!discovered) {
            manaCost = I18n.m_118938_((String)"gui.ebwizardry.spell_book.mana_cost_undiscovered", (Object[])new Object[0]);
        }
        guiGraphics.m_280056_(this.f_96547_, manaCost, left + 17, top + 69, 0, false);
        MutableComponent spellDesc = discovered ? ((MutableComponent)this.getSpell().getDesc()).m_130940_(ChatFormatting.BLACK) : Component.m_237113_((String)SpellGlyphData.getGlyphDescription(this.getSpell(), GlyphClientHandler.INSTANCE.getGlyphData())).m_130948_(Style.f_131099_.m_131150_(new ResourceLocation("minecraft", "alt")));
        guiGraphics.m_280554_(font, (FormattedText)spellDesc, left + 17, top + 83, 118, 0);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)EBSounds.MISC_BOOK_OPEN.get(), (float)1.0f));
    }
}

