/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.model;

import com.binaris.wizardry.content.entity.living.IceGiant;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class IceGiantModel
extends EntityModel<IceGiant> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("ebwizardry", "ice_giant"), "main");
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;

    public IceGiantModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.rightArm = root.m_171324_("right_arm");
        this.leftArm = root.m_171324_("left_arm");
        this.leftLeg = root.m_171324_("left_leg");
        this.rightLeg = root.m_171324_("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 10).m_171481_(-6.0f, -14.0f, -6.5f, 12.0f, 12.0f, 12.0f), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)-1.0f));
        head.m_171599_("head_spike1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -4.0f, 0.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171423_((float)-4.0f, (float)-10.0f, (float)-5.0f, (float)-0.1047198f, (float)-0.5235988f, (float)0.9599311f));
        head.m_171599_("head_spike2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, -4.0f, 0.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171423_((float)4.0f, (float)-16.0f, (float)0.0f, (float)0.5585054f, (float)0.9250245f, (float)-0.5235988f));
        head.m_171599_("head_spike3", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171423_((float)4.0f, (float)-13.0f, (float)4.0f, (float)0.7853982f, (float)-1.396263f, (float)0.7853982f));
        head.m_171599_("head_spike4", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -4.0f, 0.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171423_((float)-4.0f, (float)-16.0f, (float)0.0f, (float)0.5585054f, (float)-0.9250245f, (float)0.5235988f));
        head.m_171599_("head_spike5", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, -4.0f, 0.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171423_((float)4.0f, (float)-10.0f, (float)-5.0f, (float)0.5235988f, (float)-0.9599311f, (float)0.1047198f));
        head.m_171599_("head_spike6", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171423_((float)-4.0f, (float)-13.0f, (float)4.0f, (float)0.7853982f, (float)-1.745329f, (float)0.7853982f));
        head.m_171599_("head_spike7", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)-20.0f, (float)4.0f, (float)0.7853982f, (float)1.570796f, (float)0.7853982f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 40).m_171481_(-9.0f, -2.0f, -6.0f, 18.0f, 12.0f, 11.0f).m_171514_(0, 70).m_171481_(-4.5f, 10.0f, -3.0f, 9.0f, 5.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)0.0f));
        body.m_171599_("body_spike1", CubeListBuilder.m_171558_().m_171514_(32, 69).m_171481_(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f), PartPose.m_171423_((float)-4.0f, (float)-4.0f, (float)3.0f, (float)0.2808018f, (float)0.8096675f, (float)0.8339369f));
        body.m_171599_("body_spike2", CubeListBuilder.m_171558_().m_171514_(32, 69).m_171481_(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f), PartPose.m_171423_((float)4.0f, (float)-4.0f, (float)3.0f, (float)0.2808018f, (float)-0.8096757f, (float)-0.8339358f));
        body.m_171599_("body_spike3", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171423_((float)6.0f, (float)-2.0f, (float)-5.0f, (float)1.120006f, (float)-1.347726f, (float)-0.8969422f));
        body.m_171599_("body_spike4", CubeListBuilder.m_171558_().m_171514_(32, 69).m_171481_(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)-4.0f, (float)0.7853982f, (float)-1.570796f, (float)0.9599311f));
        body.m_171599_("body_spike5", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171423_((float)-6.0f, (float)-2.0f, (float)-5.0f, (float)1.120006f, (float)1.347725f, (float)0.896934f));
        PartDefinition rightArm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(60, 21).m_171481_(-13.0f, -2.5f, -3.0f, 4.0f, 30.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)0.0f));
        rightArm.m_171599_("right_arm_spike1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171423_((float)-11.0f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)1.134464f, (float)0.9599311f));
        rightArm.m_171599_("right_arm_spike2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171423_((float)-12.0f, (float)4.0f, (float)0.0f, (float)0.7853982f, (float)0.0f, (float)0.9599311f));
        PartDefinition leftArm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(60, 58).m_171481_(9.0f, -2.5f, -3.0f, 4.0f, 30.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)0.0f));
        leftArm.m_171599_("left_arm_spike1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171423_((float)11.0f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)-1.134464f, (float)-0.9599311f));
        leftArm.m_171599_("left_arm_spike2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171423_((float)12.0f, (float)4.0f, (float)0.0f, (float)0.7853982f, (float)0.0f, (float)-0.9599311f));
        partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(37, 0).m_171481_(-3.5f, -3.0f, -3.0f, 6.0f, 16.0f, 5.0f), PartPose.m_171419_((float)-4.0f, (float)11.0f, (float)0.0f));
        partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(60, 0).m_171480_().m_171481_(-3.5f, -3.0f, -3.0f, 6.0f, 16.0f, 5.0f), PartPose.m_171419_((float)5.0f, (float)11.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(IceGiant entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.leftLeg.f_104203_ = -1.5f * this.triangleWave(limbSwing, 13.0f) * limbSwingAmount;
        this.rightLeg.f_104203_ = 1.5f * this.triangleWave(limbSwing, 13.0f) * limbSwingAmount;
        this.leftLeg.f_104204_ = 0.0f;
        this.rightLeg.f_104204_ = 0.0f;
        int attackTimer = entity.m_28874_();
        if (attackTimer > 0) {
            float partialTicks = 1.0f;
            this.rightArm.f_104203_ = -2.0f + 1.5f * this.triangleWave((float)attackTimer - partialTicks, 10.0f);
            this.leftArm.f_104203_ = -2.0f + 1.5f * this.triangleWave((float)attackTimer - partialTicks, 10.0f);
        } else {
            this.rightArm.f_104203_ = (-0.2f + 1.5f * this.triangleWave(limbSwing, 13.0f)) * limbSwingAmount;
            this.leftArm.f_104203_ = (-0.2f - 1.5f * this.triangleWave(limbSwing, 13.0f)) * limbSwingAmount;
        }
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.head.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.body.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftLeg.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightLeg.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightArm.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftArm.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    private float triangleWave(float value, float period) {
        return (Math.abs(value % period - period * 0.5f) - period * 0.25f) / (period * 0.25f);
    }
}

