/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.particle;

import com.binaris.wizardry.api.client.particle.ParticleTargeted;
import com.binaris.wizardry.api.client.particle.ParticleWizardry;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParticleBeam
extends ParticleTargeted {
    private static final float THICKNESS = 0.1f;

    public ParticleBeam(ClientLevel world, double x, double y, double z, SpriteSet spriteProvider) {
        super(world, x, y, z, spriteProvider, false);
        this.m_107253_(1.0f, 1.0f, 1.0f);
        this.m_107257_(0);
        this.f_107663_ = 1.0f;
    }

    @Override
    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    @Override
    protected void draw(PoseStack stack, Tesselator tesselator, float length, float tickDelta) {
        float scale = this.f_107663_;
        if (this.f_107225_ > 0) {
            float ageFraction = ((float)this.f_107224_ + tickDelta - 1.0f) / (float)this.f_107225_;
            scale = this.f_107663_ * (1.0f - ageFraction * ageFraction);
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.setShaderColor((float)0.9411765f, (float)0.9411765f, (float)0.9411765f, (float)1.0f);
        for (int layer = 0; layer < 3; ++layer) {
            this.drawSegment(stack, tesselator, layer, length, 0.1f * scale);
        }
        RenderSystem.disableBlend();
    }

    private void drawSegment(PoseStack stack, Tesselator tesselator, int layer, float v, float thickness) {
        RenderSystem.setShader(GameRenderer::m_172811_);
        BufferBuilder buffer = tesselator.m_85915_();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        buffer.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
        switch (layer) {
            case 0: {
                this.drawShearedBox(stack, buffer, v, 0.25f * thickness, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 1: {
                this.drawShearedBox(stack, buffer, v, 0.6f * thickness, (this.f_107227_ + 1.0f) / 2.0f, (this.f_107228_ + 1.0f) / 2.0f, (this.f_107229_ + 1.0f) / 2.0f, 0.65f);
                break;
            }
            case 2: {
                this.drawShearedBox(stack, buffer, v, thickness, this.f_107227_, this.f_107228_, this.f_107229_, 0.3f);
            }
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        RenderSystem.enableCull();
        RenderSystem.disableDepthTest();
    }

    private void drawShearedBox(PoseStack stack, BufferBuilder buffer, float length, float width, float r, float g, float b, float a) {
        buffer.m_252986_(stack.m_85850_().m_252922_(), 0.0f - width, 0.0f - width, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(stack.m_85850_().m_252922_(), 0.0f - width, 0.0f - width, length).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(stack.m_85850_().m_252922_(), 0.0f - width, 0.0f + width, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(stack.m_85850_().m_252922_(), 0.0f - width, 0.0f + width, length).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(stack.m_85850_().m_252922_(), 0.0f + width, 0.0f + width, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(stack.m_85850_().m_252922_(), 0.0f + width, 0.0f + width, length).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(stack.m_85850_().m_252922_(), 0.0f + width, 0.0f - width, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(stack.m_85850_().m_252922_(), 0.0f + width, 0.0f - width, length).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(stack.m_85850_().m_252922_(), 0.0f - width, 0.0f - width, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(stack.m_85850_().m_252922_(), 0.0f - width, 0.0f - width, length).m_85950_(r, g, b, a).m_5752_();
    }

    public static class BeamProvider
    implements ParticleProvider<SimpleParticleType> {
        static SpriteSet spriteProvider;

        public BeamProvider(SpriteSet sprite) {
            spriteProvider = sprite;
        }

        public static ParticleWizardry createParticle(ClientLevel clientWorld, Vec3 vec3d) {
            return new ParticleBeam(clientWorld, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, spriteProvider);
        }

        @Nullable
        public Particle createParticle(@NotNull SimpleParticleType parameters, @NotNull ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new ParticleBeam(world, x, y, z, spriteProvider);
        }
    }
}

