/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.particle;

import com.binaris.wizardry.api.client.particle.ParticleWizardry;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParticleBuff
extends ParticleWizardry {
    private static final ResourceLocation TEXTURE = new ResourceLocation("ebwizardry", "textures/particle/buff.png");
    private final boolean mirror;

    public ParticleBuff(ClientLevel world, double x, double y, double z, SpriteSet spriteProvider) {
        super(world, x, y, z, spriteProvider, false);
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.162;
        this.f_107217_ = 0.0;
        this.mirror = this.random.nextBoolean();
        this.m_107257_(15);
        this.setGravity(false);
        this.f_107219_ = false;
        this.m_107253_(1.0f, 1.0f, 1.0f);
    }

    @Override
    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    @Override
    public void m_5989_() {
        super.m_5989_();
        if (this.f_107224_ > this.f_107225_ / 2) {
            this.f_107230_ = 2.0f - 2.0f * (float)this.f_107224_ / (float)this.f_107225_;
        }
    }

    @Override
    public void m_5744_(@NotNull VertexConsumer vertexConsumer, Camera camera, float partialTicks) {
        float z;
        float y;
        float x;
        this.updateEntityLinking(partialTicks);
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.texParameter((int)3553, (int)10242, (int)10497);
        RenderSystem.texParameter((int)3553, (int)10243, (int)10497);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        RenderSystem.setShader(GameRenderer::m_172820_);
        Vec3 cameraPos = camera.m_90583_();
        if (this.entity != null) {
            Vec3 entityPos = this.entity.m_20318_(partialTicks);
            x = (float)(entityPos.f_82479_ + this.relativeX - cameraPos.f_82479_);
            y = (float)(entityPos.f_82480_ + this.relativeY - cameraPos.f_82480_);
            z = (float)(entityPos.f_82481_ + this.relativeZ - cameraPos.f_82481_);
        } else {
            x = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - cameraPos.f_82479_);
            y = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - cameraPos.f_82480_);
            z = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - cameraPos.f_82481_);
        }
        float ageProgress = (float)this.f_107224_ / (float)this.f_107225_;
        float f = 0.875f - 0.125f * (float)Mth.m_14143_((float)(ageProgress * 8.0f - 1.0E-6f));
        float g = f + 0.125f;
        float textureOffset = ((float)this.f_107224_ + partialTicks) / (float)this.f_107225_ * -2.0f;
        float scale = 0.6f;
        float yScale = 0.7f * scale;
        float dx = this.mirror ? -scale : scale;
        float dz = scale;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85819_);
        this.vertex(buffer, x - dx, y - yScale, z - dz, 0.0f + textureOffset, g);
        this.vertex(buffer, x - dx, y + yScale, z - dz, 0.0f + textureOffset, f);
        this.vertex(buffer, x + dx, y - yScale, z - dz, 0.25f + textureOffset, g);
        this.vertex(buffer, x + dx, y + yScale, z - dz, 0.25f + textureOffset, f);
        this.vertex(buffer, x + dx, y - yScale, z + dz, 0.5f + textureOffset, g);
        this.vertex(buffer, x + dx, y + yScale, z + dz, 0.5f + textureOffset, f);
        this.vertex(buffer, x - dx, y - yScale, z + dz, 0.75f + textureOffset, g);
        this.vertex(buffer, x - dx, y + yScale, z + dz, 0.75f + textureOffset, f);
        this.vertex(buffer, x - dx, y - yScale, z - dz, 1.0f + textureOffset, g);
        this.vertex(buffer, x - dx, y + yScale, z - dz, 1.0f + textureOffset, f);
        tesselator.m_85914_();
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }

    private void vertex(BufferBuilder buffer, float x, float y, float z, float u, float v) {
        buffer.m_5483_((double)x, (double)y, (double)z).m_7421_(u, v).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_5752_();
    }

    @Override
    protected int m_6355_(float partialTick) {
        return 0xF000F0;
    }

    public static class BuffProvider
    implements ParticleProvider<SimpleParticleType> {
        static SpriteSet spriteProvider;

        public BuffProvider(SpriteSet sprite) {
            spriteProvider = sprite;
        }

        public static ParticleWizardry createParticle(ClientLevel clientWorld, Vec3 vec3d) {
            return new ParticleBuff(clientWorld, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, spriteProvider);
        }

        @Nullable
        public Particle createParticle(@NotNull SimpleParticleType parameters, @NotNull ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new ParticleBuff(world, x, y, z, spriteProvider);
        }
    }
}

