/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.particle;

import com.binaris.wizardry.api.client.particle.ParticleWizardry;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParticleFlash
extends ParticleWizardry {
    public ParticleFlash(ClientLevel world, double x, double y, double z, SpriteSet spriteProvider) {
        super(world, x, y, z, spriteProvider, false);
        this.m_107253_(1.0f, 1.0f, 1.0f);
        this.f_107225_ = 24;
    }

    @Override
    public void m_5744_(@NotNull VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        float ageProgress = ((float)this.f_107224_ + partialTicks) / (float)this.f_107225_;
        float exponentialFade = (float)Math.pow(1.0f - ageProgress, 3.5);
        float maxAlpha = 0.6f;
        float fadeIn = 1.0f;
        if (ageProgress < 0.2f) {
            fadeIn = Mth.m_14031_((float)(ageProgress / 0.2f * 0.5f * (float)Math.PI));
        }
        float alpha = maxAlpha * exponentialFade * fadeIn;
        this.m_107271_(Math.max(0.0f, alpha));
        super.m_5744_(buffer, renderInfo, partialTicks);
    }

    public float m_5902_(float scaleFactor) {
        float ageProgress = ((float)this.f_107224_ + scaleFactor) / (float)this.f_107225_;
        float baseScale = 0.4f;
        float growthProgress = Math.min(ageProgress * 2.5f, 1.0f);
        float sizeMultiplier = Mth.m_14031_((float)(growthProgress * 0.5f * (float)Math.PI));
        if (ageProgress > 0.3f) {
            float shrinkProgress = (ageProgress - 0.3f) / 0.7f;
            float shrinkFactor = 1.0f - shrinkProgress * 0.6f;
            sizeMultiplier *= shrinkFactor;
        }
        return baseScale * sizeMultiplier;
    }

    public static class FlashProvider
    implements ParticleProvider<SimpleParticleType> {
        static SpriteSet spriteProvider;

        public FlashProvider(SpriteSet sprite) {
            spriteProvider = sprite;
        }

        public static ParticleWizardry createParticle(ClientLevel clientWorld, Vec3 vec3d) {
            return new ParticleFlash(clientWorld, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, spriteProvider);
        }

        @Nullable
        public Particle createParticle(@NotNull SimpleParticleType parameters, @NotNull ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new ParticleFlash(world, x, y, z, spriteProvider);
        }
    }
}

