/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.particle;

import com.binaris.wizardry.api.client.particle.ParticleTargeted;
import com.binaris.wizardry.api.client.particle.ParticleWizardry;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParticleLightning
extends ParticleTargeted {
    private static final float THICKNESS = 0.04f;
    private static final float MAX_SEGMENT_LENGTH = 0.6f;
    private static final float MIN_SEGMENT_LENGTH = 0.2f;
    private static final float VERTEX_JITTER = 0.15f;
    private static final int MAX_FORK_SEGMENTS = 3;
    private static final float FORK_CHANCE = 0.3f;
    private static final int UPDATE_PERIOD = 1;

    public ParticleLightning(ClientLevel world, double x, double y, double z, SpriteSet spriteProvider) {
        super(world, x, y, z, spriteProvider, false);
        this.seed = this.random.nextLong();
        this.m_107253_(0.2f, 0.6f, 1.0f);
        this.m_107257_(3);
        this.f_107663_ = 2.4f;
    }

    @Override
    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    @Override
    protected boolean shouldApplyOriginOffset() {
        return false;
    }

    @Override
    protected void draw(PoseStack stack, Tesselator tesselator, float length, float tickDelta) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        boolean freeEnd = this.target == null;
        int numberOfSegments = Math.round(length / 0.6f);
        for (int layer = 0; layer < 3; ++layer) {
            float px = 0.0f;
            float py = 0.0f;
            float pz = 0.0f;
            this.random.setSeed(this.seed + (long)(this.f_107224_ / 1));
            for (int i = 0; i < numberOfSegments - 1; ++i) {
                float px2 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * this.f_107663_;
                float py2 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * this.f_107663_;
                float pz2 = pz + length / (float)numberOfSegments;
                this.drawSegment(stack, tesselator, layer, px, py, pz, px2, py2, pz2, 0.04f * this.f_107663_);
                if (this.random.nextFloat() < 0.3f) {
                    float px3 = px;
                    float py3 = py;
                    float pz3 = pz;
                    for (int j = 0; j < this.random.nextInt(2) + 1; ++j) {
                        float px4 = px3 + (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * this.f_107663_;
                        float py4 = py3 + (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * this.f_107663_;
                        float pz4 = pz3 + 0.2f + this.random.nextFloat() * 0.40000004f;
                        this.drawSegment(stack, tesselator, layer, px3, py3, pz3, px4, py4, pz4, 0.032f * this.f_107663_);
                        if (this.random.nextFloat() < 0.3f) {
                            float px5 = px3 + (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * this.f_107663_;
                            float py5 = py3 + (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * this.f_107663_;
                            float pz5 = pz3 + 0.2f + this.random.nextFloat() * 0.40000004f;
                            this.drawSegment(stack, tesselator, layer, px3, py3, pz3, px5, py5, pz5, 0.024f * this.f_107663_);
                        }
                        px3 = px4;
                        py3 = py4;
                        pz3 = pz4;
                    }
                }
                px = px2;
                py = py2;
                pz = pz2;
            }
            float px2 = freeEnd ? (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * this.f_107663_ : 0.0f;
            float py2 = freeEnd ? (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * this.f_107663_ : 0.0f;
            this.drawSegment(stack, tesselator, layer, px, py, pz, px2, py2, length, 0.04f * this.f_107663_);
        }
        RenderSystem.disableBlend();
    }

    private void drawSegment(PoseStack stack, Tesselator tesselator, int layer, float x1, float y1, float z1, float x2, float y2, float z2, float thickness) {
        BufferBuilder buffer = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
        switch (layer) {
            case 0: {
                this.drawShearedBox(stack, buffer, x1, y1, z1, x2, y2, z2, 0.25f * thickness, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 1: {
                this.drawShearedBox(stack, buffer, x1, y1, z1, x2, y2, z2, 0.6f * thickness, (this.f_107227_ + 1.0f) / 2.0f, (this.f_107228_ + 1.0f) / 2.0f, (this.f_107229_ + 1.0f) / 2.0f, 0.65f);
                break;
            }
            case 2: {
                this.drawShearedBox(stack, buffer, x1, y1, z1, x2, y2, z2, thickness, this.f_107227_, this.f_107228_, this.f_107229_, 0.3f);
            }
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
    }

    private void drawShearedBox(PoseStack stack, BufferBuilder buffer, float x1, float y1, float z1, float x2, float y2, float z2, float width, float r, float g, float b, float a) {
        buffer.m_252986_(stack.m_85850_().m_252922_(), x1 - width, y1 - width, z1).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(stack.m_85850_().m_252922_(), x2 - width, y2 - width, z2).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(stack.m_85850_().m_252922_(), x1 - width, y1 + width, z1).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(stack.m_85850_().m_252922_(), x2 - width, y2 + width, z2).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(stack.m_85850_().m_252922_(), x1 + width, y1 + width, z1).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(stack.m_85850_().m_252922_(), x2 + width, y2 + width, z2).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(stack.m_85850_().m_252922_(), x1 + width, y1 - width, z1).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(stack.m_85850_().m_252922_(), x2 + width, y2 - width, z2).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(stack.m_85850_().m_252922_(), x1 - width, y1 - width, z1).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(stack.m_85850_().m_252922_(), x2 - width, y2 - width, z2).m_85950_(r, g, b, a).m_5752_();
    }

    public static class LightningProvider
    implements ParticleProvider<SimpleParticleType> {
        static SpriteSet spriteProvider;

        public LightningProvider(SpriteSet sprite) {
            spriteProvider = sprite;
        }

        public static ParticleWizardry createParticle(ClientLevel clientWorld, Vec3 vec3d) {
            return new ParticleLightning(clientWorld, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, spriteProvider);
        }

        @Nullable
        public Particle createParticle(@NotNull SimpleParticleType parameters, @NotNull ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new ParticleLightning(world, x, y, z, spriteProvider);
        }
    }
}

