/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.particle;

import com.binaris.wizardry.api.client.particle.ParticleWizardry;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParticleSphere
extends ParticleWizardry {
    public ParticleSphere(ClientLevel world, double x, double y, double z, SpriteSet spriteProvider) {
        super(world, x, y, z, spriteProvider, false);
        this.m_107253_(1.0f, 1.0f, 1.0f);
        this.f_107225_ = 5;
        this.f_107230_ = 0.8f;
    }

    private static void drawSphere(PoseStack stack, BufferBuilder buffer, float radius, float latStep, float longStep, boolean inside, float r, float g, float b, float a) {
        buffer.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
        boolean goingUp = inside;
        buffer.m_252986_(stack.m_85850_().m_252922_(), 0.0f, goingUp ? -radius : radius, 0.0f).m_85950_(r, g, b, a).m_5752_();
        for (float longitude = (float)(-Math.PI); longitude <= (float)Math.PI; longitude += longStep) {
            for (float theta = 1.5707964f - latStep; theta >= -1.5707964f + latStep; theta -= latStep) {
                float latitude = goingUp ? -theta : theta;
                float hRadius = radius * Mth.m_14089_((float)latitude);
                float vy = radius * Mth.m_14031_((float)latitude);
                float vx = hRadius * Mth.m_14031_((float)longitude);
                float vz = hRadius * Mth.m_14089_((float)longitude);
                buffer.m_252986_(stack.m_85850_().m_252922_(), vx, vy, vz).m_85950_(r, g, b, a).m_5752_();
                vx = hRadius * Mth.m_14031_((float)(longitude + longStep));
                vz = hRadius * Mth.m_14089_((float)(longitude + longStep));
                buffer.m_252986_(stack.m_85850_().m_252922_(), vx, vy, vz).m_85950_(r, g, b, a).m_5752_();
            }
            buffer.m_252986_(stack.m_85850_().m_252922_(), 0.0f, goingUp ? radius : -radius, 0.0f).m_85950_(r, g, b, a).m_5752_();
            goingUp = !goingUp;
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
    }

    @Override
    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    @Override
    public void m_5744_(@NotNull VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        RenderSystem.setShader(GameRenderer::m_172811_);
        PoseStack stack = new PoseStack();
        this.updateEntityLinking(tickDelta);
        float x = (float)(this.f_107209_ + (this.f_107212_ - this.f_107209_) * (double)tickDelta);
        float y = (float)(this.f_107210_ + (this.f_107213_ - this.f_107210_) * (double)tickDelta);
        float z = (float)(this.f_107211_ + (this.f_107214_ - this.f_107211_) * (double)tickDelta);
        stack.m_85836_();
        stack.m_85837_((double)x - camera.m_90583_().f_82479_, (double)y - camera.m_90583_().f_82480_, (double)z - camera.m_90583_().f_82481_);
        RenderSystem.enableBlend();
        RenderSystem.enableCull();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        float latStep = 0.15707964f;
        float longStep = 0.15707964f;
        float size = this.f_107663_ * 10.0f;
        float sphereRadius = size * ((float)this.f_107224_ + tickDelta - 1.0f) / (float)this.f_107225_;
        float alpha = this.f_107230_ * (1.0f - ((float)this.f_107224_ + tickDelta - 1.0f) / (float)this.f_107225_);
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder buffer = tess.m_85915_();
        ParticleSphere.drawSphere(stack, buffer, sphereRadius, latStep, longStep, true, this.f_107227_, this.f_107228_, this.f_107229_, alpha);
        ParticleSphere.drawSphere(stack, buffer, sphereRadius, latStep, longStep, false, this.f_107227_, this.f_107228_, this.f_107229_, alpha);
        RenderSystem.disableCull();
        RenderSystem.disableBlend();
        stack.m_85849_();
    }

    public static class SphereProvider
    implements ParticleProvider<SimpleParticleType> {
        static SpriteSet spriteSet;

        public SphereProvider(SpriteSet sprite) {
            spriteSet = sprite;
        }

        public static ParticleWizardry createParticle(ClientLevel clientWorld, Vec3 vec3d) {
            return new ParticleSphere(clientWorld, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, spriteSet);
        }

        @Nullable
        public Particle createParticle(@NotNull SimpleParticleType parameters, @NotNull ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new ParticleSphere(world, x, y, z, spriteSet);
        }
    }
}

