/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.renderer.blockentity;

import com.binaris.wizardry.content.blockentity.ArcaneWorkbenchBlockEntity;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ArcaneWorkbenchRender
implements BlockEntityRenderer<ArcaneWorkbenchBlockEntity> {
    private static final ResourceLocation RUNE_TEXTURE = new ResourceLocation("ebwizardry", "textures/entity/arcane_workbench_rune.png");
    public int time;

    public ArcaneWorkbenchRender(BlockEntityRendererProvider.Context context) {
    }

    public void render(ArcaneWorkbenchBlockEntity entity, float partialTicks, PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        float f1;
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 1.5f, 0.5f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        poseStack.m_85836_();
        for (f1 = entity.rot - entity.oRot; f1 >= (float)Math.PI; f1 -= (float)Math.PI * 2) {
        }
        while (f1 < (float)(-Math.PI)) {
            f1 += (float)Math.PI * 2;
        }
        double angle = Math.toDegrees(entity.oRot + f1 * partialTicks);
        this.renderEffect(poseStack, entity, partialTicks);
        this.renderWand(poseStack, entity, angle, partialTicks, packedLight, bufferSource);
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    private void renderEffect(PoseStack poseStack, ArcaneWorkbenchBlockEntity entity, float partialTicks) {
        ItemStack stack = entity.m_8020_(9);
        if (stack.m_41619_()) {
            return;
        }
        poseStack.m_85836_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(entity.timer + partialTicks));
        poseStack.m_252880_(0.0f, 0.65f, 0.0f);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)RUNE_TEXTURE);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), -0.5f, 0.0f, -0.5f).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), 0.5f, 0.0f, -0.5f).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), 0.5f, 0.0f, 0.5f).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), -0.5f, 0.0f, 0.5f).m_7421_(0.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    private void renderWand(PoseStack posestack, ArcaneWorkbenchBlockEntity entity, double v, float partialTicks, int light, MultiBufferSource bufferSource) {
        ItemStack stack = entity.m_8020_(9);
        if (stack.m_41619_()) {
            return;
        }
        posestack.m_85836_();
        posestack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        posestack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        posestack.m_252781_(Axis.f_252403_.m_252977_((float)(v + 45.0)));
        posestack.m_252880_(0.0f, 0.0f, 0.56f + 0.05f * Mth.m_14031_((float)((entity.timer + partialTicks) / 15.0f)));
        posestack.m_85841_(0.75f, 0.75f, 0.75f);
        Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, light, OverlayTexture.f_118083_, posestack, bufferSource, null, 0);
        posestack.m_85849_();
    }
}

