/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.renderer.blockentity;

import com.binaris.wizardry.content.blockentity.ImbuementAltarBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public class ImbuementAltarRenderer
implements BlockEntityRenderer<ImbuementAltarBlockEntity> {
    public ImbuementAltarRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(ImbuementAltarBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 1.4f, 0.5f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        float t = (float)blockEntity.m_58904_().m_46467_() + partialTick;
        float bobAmount = 0.05f * Mth.m_14031_((float)(t / 15.0f));
        poseStack.m_252880_(0.0f, bobAmount, 0.0f);
        this.renderItem(blockEntity, t, poseStack, bufferSource, packedLight, packedOverlay);
        this.renderRays(blockEntity, partialTick, poseStack, bufferSource);
        poseStack.m_85849_();
    }

    private void renderItem(ImbuementAltarBlockEntity blockEntity, float t, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ItemStack stack = blockEntity.getStack();
        if (!stack.m_41619_()) {
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(t));
            poseStack.m_85841_(0.85f, 0.85f, 0.85f);
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            itemRenderer.m_269128_(stack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.m_58904_(), 0);
            poseStack.m_85849_();
        }
    }

    private void renderRays(ImbuementAltarBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource) {
        if (blockEntity.getStack().m_41619_()) {
            return;
        }
        if (blockEntity.getImbuementProgress() <= 0.0f) {
            return;
        }
        if (blockEntity.getElement() == null) {
            return;
        }
        float t = (float)blockEntity.m_58904_().m_46467_() + partialTick;
        Random random = new Random(blockEntity.m_58899_().m_121878_());
        int[] colors = blockEntity.getElement().getColors();
        int r1 = colors[1] >> 16 & 0xFF;
        int g1 = colors[1] >> 8 & 0xFF;
        int b1 = colors[1] & 0xFF;
        int r2 = colors[2] >> 16 & 0xFF;
        int g2 = colors[2] >> 8 & 0xFF;
        int b2 = colors[2] & 0xFF;
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110502_());
        for (int j = 0; j < 30; ++j) {
            int m = random.nextInt(10);
            int n = random.nextInt(10);
            int sliceAngle = 20 + m;
            float scale = 0.5f;
            poseStack.m_85836_();
            float rawProgress = blockEntity.getImbuementProgress();
            float progress = Math.min(rawProgress + partialTick / 141.0f, 1.0f);
            float s = 1.0f - progress;
            s = 1.0f - s * s;
            poseStack.m_85841_(s, s, s);
            float rotationVariation = Mth.m_14031_((float)((t + (float)(j * 10)) * 0.01f)) * 5.0f;
            poseStack.m_252781_(Axis.f_252529_.m_252977_((float)(31 * m) + rotationVariation));
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)(31 * n) + rotationVariation));
            float fade = (Math.min(1.0f, 1.9f - progress) - 0.9f) * 10.0f;
            Matrix4f matrix = poseStack.m_85850_().m_252922_();
            double x1 = scale * Mth.m_14031_((float)((t + (float)(40 * j)) * ((float)Math.PI / 180)));
            double z1 = scale * Mth.m_14089_((float)((t + (float)(40 * j)) * ((float)Math.PI / 180)));
            double x2 = scale * Mth.m_14031_((float)((t + (float)(40 * j) - (float)sliceAngle) * ((float)Math.PI / 180)));
            double z2 = scale * Mth.m_14089_((float)((t + (float)(40 * j) - (float)sliceAngle) * ((float)Math.PI / 180)));
            int alpha1 = (int)(255.0f * fade);
            int alpha2 = (int)(200.0f * fade);
            buffer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_6122_(r1, g1, b1, alpha1).m_5752_();
            buffer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_6122_(r1, g1, b1, alpha1).m_5752_();
            buffer.m_252986_(matrix, (float)x1, 0.0f, (float)z1).m_6122_(r2, g2, b2, alpha2).m_5752_();
            buffer.m_252986_(matrix, (float)x2, 0.0f, (float)z2).m_6122_(r2, g2, b2, alpha2).m_5752_();
            poseStack.m_85849_();
        }
    }

    public int m_142163_() {
        return 64;
    }
}

