/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.renderer.entity;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.content.util.DrawingUtils;
import com.binaris.wizardry.client.model.BoulderModel;
import com.binaris.wizardry.content.entity.construct.BoulderConstruct;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class BoulderRenderer
extends EntityRenderer<BoulderConstruct> {
    private static final ResourceLocation TEXTURE = WizardryMainMod.location("textures/entity/boulder.png");
    private final BoulderModel model;

    public BoulderRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new BoulderModel(context.m_174023_(BoulderModel.LAYER_LOCATION));
    }

    public void render(BoulderConstruct entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, entity.m_20206_() / 2.0f, 0.0f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(yaw - 90.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(entity.f_19860_ + (entity.m_146909_() - entity.f_19860_) * partialTicks));
        poseStack.m_252880_(0.0f, -entity.m_20206_() / 2.0f, 0.0f);
        float s = DrawingUtils.smoothScaleFactor(-1, entity.f_19797_, partialTicks, 10, 10);
        poseStack.m_85841_(s *= entity.getSizeMultiplier(), s, s);
        poseStack.m_85837_(0.0, 0.875, 0.0);
        this.model.m_7695_(poseStack, buffer.m_6299_(RenderType.m_110470_((ResourceLocation)TEXTURE)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull BoulderConstruct construct) {
        return TEXTURE;
    }
}

