/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.renderer.entity;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.content.entity.construct.BubbleConstruct;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class BubbleRenderer
extends EntityRenderer<BubbleConstruct> {
    private static final ResourceLocation BUBBLE_TEXTURE = new ResourceLocation("textures/particle/bubble.png");
    private static final ResourceLocation ENTRAPMENT_TEXTURE = WizardryMainMod.location("textures/entity/entrapment.png");
    private static final float BUBBLE_SIZE_MULTIPLIER = 1.1f;

    public BubbleRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(@NotNull BubbleConstruct entity, float entityYaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffers, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_252781_(this.f_114476_.m_253208_());
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        ResourceLocation tex = this.getTextureLocation(entity);
        VertexConsumer vc = buffers.m_6299_(RenderType.m_110473_((ResourceLocation)tex));
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        float size = this.calculateBubbleSize(entity);
        float top = size * 2.0f;
        this.addVertex(vc, pose, normal, -size, 0.0f, 0.0f, 1.0f, packedLight);
        this.addVertex(vc, pose, normal, size, 0.0f, 1.0f, 1.0f, packedLight);
        this.addVertex(vc, pose, normal, size, top, 1.0f, 0.0f, packedLight);
        this.addVertex(vc, pose, normal, -size, top, 0.0f, 0.0f, packedLight);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, buffers, packedLight);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull BubbleConstruct construct) {
        return construct.isDarkOrb() ? ENTRAPMENT_TEXTURE : BUBBLE_TEXTURE;
    }

    private float calculateBubbleSize(BubbleConstruct entity) {
        Entity trapped = EntityUtil.getRider(entity);
        if (trapped != null) {
            float width = trapped.m_20205_();
            float height = trapped.m_20206_() / 2.0f;
            return Math.max(width, height) * 1.1f;
        }
        return 1.0f;
    }

    private void addVertex(VertexConsumer vc, Matrix4f pose, Matrix3f normal, float x, float y, float u, float v, int packedLight) {
        vc.m_252986_(pose, x, y, 0.0f).m_6122_(255, 255, 255, 200).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

