/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.renderer.entity;

import com.binaris.wizardry.client.model.RemnantModel;
import com.binaris.wizardry.content.entity.living.Remnant;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public class RemnantRenderer
extends EntityRenderer<Remnant> {
    private static final ResourceLocation TEX = new ResourceLocation("ebwizardry", "textures/entity/remnant.png");
    private static final RenderType RENDER_TYPE = RenderType.m_110458_((ResourceLocation)TEX);
    private final RemnantModel model;

    public RemnantRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.f_114477_ = 0.5f;
        this.model = new RemnantModel(ctx.m_174023_(RemnantModel.LAYER_LOCATION));
    }

    public void render(Remnant entity, float entityYaw, float partialTicks, PoseStack ps, MultiBufferSource buffer, int packedLight) {
        float age = (float)entity.f_19797_ + partialTicks;
        float expansion = 0.9f;
        if (entity.f_20919_ > 0) {
            f = ((float)entity.f_20919_ + partialTicks) * 0.25f;
            f = 1.0f - 1.0f / (f + 1.0f);
            expansion -= f * 0.75f;
        } else if (entity.f_20916_ > 0) {
            f = ((float)entity.f_20916_ - partialTicks) / (float)entity.f_20917_;
            f = Mth.m_14031_((float)(f * f * f * f * (float)Math.PI));
            expansion += f * 0.2f;
        }
        float rotationSpeed = entity.m_6069_() ? 10.0f : 3.0f;
        ps.m_85836_();
        ps.m_85837_(0.0, (double)entity.m_20206_() / 2.0, 0.0);
        ps.m_85836_();
        ps.m_85841_(expansion, expansion, expansion);
        ps.m_252781_(Axis.f_252436_.m_252977_(age * rotationSpeed / 2.0f));
        ps.m_252781_(new Quaternionf().setAngleAxis((float)Math.toRadians(60.0), (float)Math.sin(0.7853981633974483), 0.0f, (float)Math.sin(0.7853981633974483)));
        ps.m_252781_(Axis.f_252436_.m_252977_(age * rotationSpeed));
        VertexConsumer vb = buffer.m_6299_(RENDER_TYPE);
        this.model.m_7695_(ps, vb, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        ps.m_85849_();
        ps.m_85836_();
        ps.m_85841_(0.875f, 0.875f, 0.875f);
        ps.m_252781_(new Quaternionf().setAngleAxis((float)Math.toRadians(60.0), (float)Math.sin(0.7853981633974483), 0.0f, (float)Math.sin(0.7853981633974483)));
        ps.m_252781_(Axis.f_252436_.m_252977_(age * rotationSpeed));
        this.model.m_7695_(ps, vb, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        ps.m_85849_();
        ps.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, ps, buffer, packedLight);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull Remnant entity) {
        return TEX;
    }

    public boolean shouldRender(Remnant livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return super.m_5523_((Entity)livingEntity, camera, camX, camY, camZ);
    }
}

