/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.renderer.entity;

import com.binaris.wizardry.api.content.entity.construct.MagicConstructEntity;
import com.binaris.wizardry.api.content.util.DrawingUtils;
import com.binaris.wizardry.core.AllyDesignation;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class SigilRenderer
extends EntityRenderer<MagicConstructEntity> {
    private final ResourceLocation texture;
    private final float rotationSpeed;
    private final boolean invisibleToEnemies;

    public SigilRenderer(EntityRendererProvider.Context p_174008_, ResourceLocation texture, float rotationSpeed, boolean invisibleToEnemies) {
        super(p_174008_);
        this.texture = texture;
        this.rotationSpeed = rotationSpeed;
        this.invisibleToEnemies = invisibleToEnemies;
    }

    public void render(@NotNull MagicConstructEntity entity, float p_114486_, float partialTicks, @NotNull PoseStack poseStack, MultiBufferSource p_114489_, int p_114490_) {
        LivingEntity livingEntity;
        if (this.invisibleToEnemies && entity.getCaster() != Minecraft.m_91087_().f_91074_ && (livingEntity = entity.getCaster()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (!AllyDesignation.isPlayerAlly((Player)entity.getCaster(), player)) {
                return;
            }
        }
        poseStack.m_85836_();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        float yOffset = 0.0f;
        poseStack.m_252880_(0.0f, yOffset, 0.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        float f6 = 1.0f;
        float f7 = 0.5f;
        float f8 = 0.5f;
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        if (this.rotationSpeed != 0.0f) {
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)entity.f_19797_ * this.rotationSpeed));
        }
        float s = entity.m_20205_() * DrawingUtils.smoothScaleFactor(entity.lifetime, entity.f_19797_, partialTicks, 10, 10);
        poseStack.m_85841_(s, s, s);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), 0.0f - f7, 0.0f - f8, 0.01f).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), f6 - f7, 0.0f - f8, 0.01f).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), f6 - f7, 1.0f - f8, 0.01f).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), 0.0f - f7, 1.0f - f8, 0.01f).m_7421_(0.0f, 0.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull MagicConstructEntity entity) {
        return null;
    }
}

