/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.renderer.entity;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.content.util.DrawingUtils;
import com.binaris.wizardry.api.content.util.GeometryUtil;
import com.binaris.wizardry.content.entity.construct.ZombieSpawnerConstruct;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ZombieSpawnerRenderer
extends EntityRenderer<ZombieSpawnerConstruct> {
    private static final ResourceLocation TEXTURE = WizardryMainMod.location("textures/entity/zombie_spawner.png");
    private static final Vec3[] HIDDEN_BOX = GeometryUtil.getVertices(new AABB(-1.0, 0.0, -1.0, 1.0, 2.5, 1.0));

    public ZombieSpawnerRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    private static void drawFace(PoseStack stack, BufferBuilder buffer, Vec3 topLeft, Vec3 topRight, Vec3 bottomLeft, Vec3 bottomRight) {
        buffer.m_252986_(stack.m_85850_().m_252922_(), (float)topLeft.f_82479_, (float)topLeft.f_82480_, (float)topLeft.f_82481_).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_252986_(stack.m_85850_().m_252922_(), (float)topRight.f_82479_, (float)topRight.f_82480_, (float)topRight.f_82481_).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_252986_(stack.m_85850_().m_252922_(), (float)bottomRight.f_82479_, (float)bottomRight.f_82480_, (float)bottomRight.f_82481_).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_252986_(stack.m_85850_().m_252922_(), (float)bottomLeft.f_82479_, (float)bottomLeft.f_82480_, (float)bottomLeft.f_82481_).m_7421_(0.0f, 1.0f).m_5752_();
    }

    private static void drawFaceColour(PoseStack stack, BufferBuilder buffer, Vec3 topLeft, Vec3 topRight, Vec3 bottomLeft, Vec3 bottomRight) {
        buffer.m_252986_(stack.m_85850_().m_252922_(), (float)topLeft.f_82479_, (float)topLeft.f_82480_, (float)topLeft.f_82481_).m_85950_(0.0f, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(stack.m_85850_().m_252922_(), (float)topRight.f_82479_, (float)topRight.f_82480_, (float)topRight.f_82481_).m_85950_(0.0f, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(stack.m_85850_().m_252922_(), (float)bottomRight.f_82479_, (float)bottomRight.f_82480_, (float)bottomRight.f_82481_).m_85950_(0.0f, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(stack.m_85850_().m_252922_(), (float)bottomLeft.f_82479_, (float)bottomLeft.f_82480_, (float)bottomLeft.f_82481_).m_85950_(0.0f, 0.0f, 0.0f, 1.0f).m_5752_();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull ZombieSpawnerConstruct construct) {
        return TEXTURE;
    }

    public void render(ZombieSpawnerConstruct entity, float entityYaw, float partialTicks, PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        poseStack.m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        poseStack.m_85836_();
        float s = DrawingUtils.smoothScaleFactor(entity.lifetime, entity.f_19797_, partialTicks, 10, 10);
        poseStack.m_85841_(s, s, s);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(((float)entity.f_19797_ + partialTicks) * 2.0f));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        Vec3[] vertices = GeometryUtil.getVertices(entity.m_20191_().m_82383_(entity.m_20182_().m_82490_(-1.0)));
        RenderSystem.setShader(GameRenderer::m_172817_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        ZombieSpawnerRenderer.drawFace(poseStack, buffer, vertices[0], vertices[1], vertices[3], vertices[2]);
        ZombieSpawnerRenderer.drawFace(poseStack, buffer, vertices[1], vertices[0], vertices[2], vertices[3]);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        poseStack.m_85849_();
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        RenderSystem.setShader(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        ZombieSpawnerRenderer.drawFaceColour(poseStack, buffer, HIDDEN_BOX[6], HIDDEN_BOX[7], HIDDEN_BOX[2], HIDDEN_BOX[3]);
        ZombieSpawnerRenderer.drawFaceColour(poseStack, buffer, HIDDEN_BOX[5], HIDDEN_BOX[6], HIDDEN_BOX[1], HIDDEN_BOX[2]);
        ZombieSpawnerRenderer.drawFaceColour(poseStack, buffer, HIDDEN_BOX[4], HIDDEN_BOX[5], HIDDEN_BOX[0], HIDDEN_BOX[1]);
        ZombieSpawnerRenderer.drawFaceColour(poseStack, buffer, HIDDEN_BOX[7], HIDDEN_BOX[4], HIDDEN_BOX[3], HIDDEN_BOX[0]);
        ZombieSpawnerRenderer.drawFaceColour(poseStack, buffer, HIDDEN_BOX[5], HIDDEN_BOX[4], HIDDEN_BOX[6], HIDDEN_BOX[7]);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        RenderSystem.disableBlend();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        poseStack.m_85849_();
    }
}

