/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.sound;

import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.content.event.EBClientTickEvent;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;

public abstract class SoundLoop
extends AbstractTickableSoundInstance {
    private static final Set<SoundLoop> activeLoops = new HashSet<SoundLoop>();
    private final SoundInstance startPrimer;
    private final SoundInstance start;
    private final SoundInstance loop;
    private final SoundInstance end;
    private boolean looping = false;
    private boolean needsRemoving = false;

    public SoundLoop(SoundEvent start, SoundEvent loop, SoundEvent end, SoundSource category, float volume, ISoundFactory factory) {
        super(end, category, Minecraft.m_91087_().f_91073_.f_46441_);
        this.startPrimer = factory.create(start, category, 1.0E-5f, false);
        this.start = factory.create(start, category, volume, false);
        this.loop = factory.create(loop, category, volume, true);
        this.end = factory.create(end, category, volume, false);
    }

    public static void addLoop(SoundLoop loop) {
        activeLoops.add(loop);
        Minecraft.m_91087_().m_91106_().m_120367_(loop.startPrimer);
        Minecraft.m_91087_().m_91106_().m_120369_(loop.start, 2);
    }

    protected static boolean hasActiveLoopMatching(Predicate<SoundLoop> predicate) {
        return activeLoops.stream().anyMatch(predicate);
    }

    public static void onClientTick(EBClientTickEvent event) {
        activeLoops.stream().filter(s -> s.needsRemoving).forEach(SoundLoop::stopStartAndLoop);
        activeLoops.removeIf(s -> s.needsRemoving);
        activeLoops.forEach(SoundLoop::m_7788_);
    }

    public void m_7788_() {
        if (!this.looping && !Minecraft.m_91087_().m_91106_().m_120403_(this.startPrimer)) {
            EBLogger.warn("SoundLoop: Starting loop sound.", new Object[0]);
            Minecraft.m_91087_().m_91106_().m_120367_(this.loop);
            this.looping = true;
        }
    }

    public void endLoop() {
        Minecraft.m_91087_().m_91106_().m_120367_(this.end);
        this.needsRemoving = true;
    }

    protected void stopStartAndLoop() {
        Minecraft.m_91087_().m_91106_().m_120399_(this.startPrimer);
        Minecraft.m_91087_().m_91106_().m_120399_(this.start);
        Minecraft.m_91087_().m_91106_().m_120399_(this.loop);
    }

    @FunctionalInterface
    public static interface ISoundFactory {
        public SoundInstance create(SoundEvent var1, SoundSource var2, float var3, boolean var4);
    }
}

