/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.client.sound;

import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.client.sound.MovingSoundEntity;
import com.binaris.wizardry.client.sound.SoundLoop;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;

public abstract class SoundLoopSpell
extends SoundLoop {
    final Spell spell;

    public SoundLoopSpell(SoundEvent start, SoundEvent loop, SoundEvent end, float volume, SoundLoop.ISoundFactory factory, Spell spell) {
        super(start, loop, end, SoundSource.PLAYERS, volume, factory);
        this.spell = spell;
    }

    public static boolean hasActiveLoop(LivingEntity entity, Spell spell) {
        return SoundLoop.hasActiveLoopMatching(loop -> {
            if (!(loop instanceof SoundLoopSpellEntity)) return false;
            SoundLoopSpellEntity spellLoop = (SoundLoopSpellEntity)((Object)loop);
            if (spellLoop.source != entity) return false;
            if (spellLoop.spell != spell) return false;
            return true;
        });
    }

    protected abstract boolean stillCasting(Spell var1);

    @Override
    public void m_7788_() {
        if (this.stillCasting(this.spell)) {
            super.m_7788_();
        } else {
            this.endLoop();
        }
    }

    public static class SoundLoopSpellEntity
    extends SoundLoopSpell {
        private final LivingEntity source;

        public SoundLoopSpellEntity(SoundEvent start, SoundEvent loop, SoundEvent end, Spell spell, LivingEntity source, float volume, float pitch) {
            super(start, loop, end, volume, (sound, category, v, repeat) -> new MovingSoundEntity<LivingEntity>(source, sound, category, v, pitch, repeat), spell);
            this.source = source;
        }

        @Override
        protected boolean stillCasting(Spell spell) {
            return EntityUtil.isCasting(this.source, spell);
        }
    }

    public static class SoundLoopSpellPosTimed
    extends SoundLoopSpellLocation {
        private int timeLeft;

        public SoundLoopSpellPosTimed(SoundEvent start, SoundEvent loop, SoundEvent end, Spell spell, int duration, double x, double y, double z, float sndVolume, float sndPitch) {
            super(start, loop, end, spell, x, y, z, sndVolume, sndPitch);
            this.timeLeft = duration;
        }

        @Override
        public void m_7788_() {
            super.m_7788_();
            --this.timeLeft;
        }

        @Override
        protected boolean stillCasting(Spell spell) {
            return this.timeLeft > 0;
        }
    }

    public static class SoundLoopSpellDispenser
    extends SoundLoopSpellLocation {
        private final DispenserBlockEntity source;

        public SoundLoopSpellDispenser(SoundEvent start, SoundEvent loop, SoundEvent end, Spell spell, Level world, double x, double y, double z, float sndVolume, float sndPitch) {
            super(start, loop, end, spell, x, y, z, sndVolume, sndPitch);
            BlockEntity tileentity = world.m_7702_(BlockPos.m_274561_((double)x, (double)y, (double)z));
            if (!(tileentity instanceof DispenserBlockEntity)) {
                throw new NullPointerException(String.format("Playing continuous spell sound: no dispenser found at %s, %s, %s", x, y, z));
            }
            this.source = (DispenserBlockEntity)tileentity;
        }

        @Override
        protected boolean stillCasting(Spell spell) {
            return false;
        }
    }

    public static abstract class SoundLoopSpellLocation
    extends SoundLoopSpell {
        public SoundLoopSpellLocation(SoundEvent start, SoundEvent loop, SoundEvent end, Spell spell, double x, double y, double z, float sndVolume, final float sndPitch) {
            super(start, loop, end, sndVolume, (sound, category, v, r) -> new AbstractSoundInstance(sound, category, Minecraft.m_91087_().f_91073_.f_46441_){
                {
                    super(soundEvent, source, random);
                    this.f_119575_ = (float)this.f_119575_;
                    this.f_119576_ = (float)this.f_119576_;
                    this.f_119577_ = (float)this.f_119577_;
                    this.f_119578_ = r;
                    this.f_119573_ = v;
                    this.f_119574_ = sndPitch;
                }
            }, spell);
        }
    }
}

