/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content;

import com.binaris.wizardry.WizardryMainMod;
import com.binaris.wizardry.api.content.data.SpellManagerData;
import com.binaris.wizardry.api.content.data.WizardData;
import com.binaris.wizardry.api.content.event.EBDiscoverSpellEvent;
import com.binaris.wizardry.api.content.event.SpellCastEvent;
import com.binaris.wizardry.api.content.item.IManaStoringItem;
import com.binaris.wizardry.api.content.item.ISpellCastingItem;
import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.content.ForfeitRegistry;
import com.binaris.wizardry.core.EBConfig;
import com.binaris.wizardry.core.event.WizardryEventBus;
import com.binaris.wizardry.core.integrations.accessories.EBAccessoriesIntegration;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBAdvancementTriggers;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.EBSounds;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class Forfeit {
    protected final SoundEvent sound;
    private final ResourceLocation name;
    private final Element element;
    private final SpellTier spellTier;
    @Nullable
    private final BiConsumer<Level, Player> effect;

    public Forfeit(ResourceLocation name, Element element, SpellTier spellTier, @Nullable BiConsumer<Level, Player> effect) {
        this.name = name;
        this.sound = SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(name.m_135827_(), "forfeit." + name.m_135815_()));
        this.element = element;
        this.spellTier = spellTier;
        this.effect = effect;
    }

    public Forfeit(String name, Element element, SpellTier spellTier, @Nullable BiConsumer<Level, Player> effect) {
        this(WizardryMainMod.location(name), element, spellTier, effect);
    }

    public static void onSpellCastPreEvent(SpellCastEvent.Pre event) {
        Player p;
        Player player;
        LivingEntity livingEntity = event.getCaster();
        Player player2 = player = livingEntity instanceof Player ? (p = (Player)livingEntity) : null;
        if (player == null || player.m_7500_()) {
            return;
        }
        if (event.getSource() != SpellCastEvent.Source.WAND && event.getSource() != SpellCastEvent.Source.SCROLL) {
            return;
        }
        SpellManagerData spellData = Services.OBJECT_DATA.getSpellManagerData(player);
        WizardData wizardData = Services.OBJECT_DATA.getWizardData(player);
        if (spellData.hasSpellBeenDiscovered(event.getSpell())) {
            return;
        }
        ForfeitResult result = Forfeit.calculateForfeit(player, spellData, wizardData, event.getSpell());
        if (!result.shouldTrigger) {
            return;
        }
        event.setCanceled(true);
        Forfeit.applyForfeitToPlayer(event, player, result.forfeit);
    }

    private static ForfeitResult calculateForfeit(Player player, SpellManagerData spellData, WizardData wizardData, Spell spell) {
        float chance = (float)EBConfig.forfeitChance;
        if (EBAccessoriesIntegration.isEquipped(player, EBItems.AMULET_WISDOM.get())) {
            chance *= 0.5f;
        }
        boolean isUndiscovered = !spellData.hasSpellBeenDiscovered(spell);
        Random random = wizardData.getRandom();
        float roll = random.nextFloat();
        Forfeit forfeit = ForfeitRegistry.getRandomForfeit(random, spell.getTier(), spell.getElement());
        boolean shouldTrigger = roll < chance && isUndiscovered;
        return new ForfeitResult(shouldTrigger, forfeit);
    }

    private static void applyForfeitToPlayer(SpellCastEvent.Pre event, Player player, Forfeit forfeit) {
        Component message;
        if (forfeit == null) {
            player.m_213846_((Component)Component.m_237115_((String)"forfeit.ebwizardry.do_nothing"));
            return;
        }
        forfeit.apply(event.getLevel(), player);
        Forfeit.consumeResourceForForfeit(event, player);
        if (player instanceof ServerPlayer) {
            EBAdvancementTriggers.SPELL_FAILURE.triggerFor(player);
        }
        EntityUtil.playSoundAtPlayer(player, forfeit.getSound(), 1.0f, 1.0f);
        Component component = message = event.getSource() == SpellCastEvent.Source.WAND ? forfeit.getMessageForWand() : forfeit.getMessageForScroll();
        if (!player.m_9236_().f_46443_) {
            player.m_5661_(message, true);
        }
    }

    public static void onSpellCastPostEvent(SpellCastEvent.Post event) {
        LivingEntity livingEntity = event.getCaster();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            EBAdvancementTriggers.CAST_SPELL.trigger(serverPlayer, event.getSpell(), player.m_21120_(player.m_7655_()));
        }
        if (!event.getLevel().m_5776_()) {
            Forfeit.discoverSpell(player, event.getSpell());
        }
    }

    private static void discoverSpell(Player player, Spell spell) {
        SpellManagerData data = Services.OBJECT_DATA.getSpellManagerData(player);
        boolean eventCancelled = WizardryEventBus.getInstance().fire(new EBDiscoverSpellEvent(player, spell, EBDiscoverSpellEvent.Source.CASTING));
        if (eventCancelled || !data.discoverSpell(spell)) {
            return;
        }
        if (!player.m_9236_().f_46443_ && !player.m_7500_()) {
            EntityUtil.playSoundAtPlayer(player, EBSounds.MISC_DISCOVER_SPELL.get(), 1.25f, 1.0f);
            MutableComponent message = Component.m_237110_((String)"spell.discover", (Object[])new Object[]{spell.getDescriptionFormatted()});
            player.m_213846_((Component)message);
        }
    }

    private static void consumeResourceForForfeit(SpellCastEvent.Pre event, Player player) {
        ItemStack stack = Forfeit.findCastingItem(player);
        if (stack.m_41619_()) {
            return;
        }
        if (event.getSource() == SpellCastEvent.Source.SCROLL) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
        } else {
            Item item = stack.m_41720_();
            if (item instanceof IManaStoringItem) {
                IManaStoringItem manaItem = (IManaStoringItem)item;
                int cost = (int)((float)event.getSpell().getCost() * event.getModifiers().get("cost") + 0.1f);
                manaItem.consumeMana(stack, cost, (LivingEntity)player);
            }
        }
    }

    private static ItemStack findCastingItem(Player player) {
        ItemStack mainHand = player.m_21205_();
        if (mainHand.m_41720_() instanceof ISpellCastingItem) {
            return mainHand;
        }
        ItemStack offHand = player.m_21206_();
        if (offHand.m_41720_() instanceof ISpellCastingItem) {
            return offHand;
        }
        return ItemStack.f_41583_;
    }

    public void apply(Level world, Player player) {
        if (this.effect != null) {
            this.effect.accept(world, player);
        }
    }

    public Component getMessage(Component implementName) {
        return Component.m_237110_((String)("forfeit." + this.name.m_135827_() + "." + this.name.m_135815_()), (Object[])new Object[]{implementName});
    }

    public Component getMessageForWand() {
        return this.getMessage((Component)Component.m_237115_((String)"item.ebwizardry.wand.generic"));
    }

    public Component getMessageForScroll() {
        return this.getMessage((Component)Component.m_237115_((String)"item.ebwizardry.scroll.generic"));
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public SoundEvent getSound() {
        return this.sound;
    }

    public Element getElement() {
        return this.element;
    }

    public SpellTier getSpellTier() {
        return this.spellTier;
    }

    private record ForfeitResult(boolean shouldTrigger, Forfeit forfeit) {
    }
}

