/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content;

import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.api.content.spell.SpellContext;
import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.content.Forfeit;
import com.binaris.wizardry.content.entity.ArrowRainConstruct;
import com.binaris.wizardry.content.entity.MeteorEntity;
import com.binaris.wizardry.content.entity.construct.BlizzardConstruct;
import com.binaris.wizardry.content.entity.construct.HailstormConstruct;
import com.binaris.wizardry.content.entity.construct.IceSpikeConstruct;
import com.binaris.wizardry.content.entity.construct.LightningSigilConstruct;
import com.binaris.wizardry.content.entity.living.IceGiant;
import com.binaris.wizardry.content.entity.living.IceWraith;
import com.binaris.wizardry.content.entity.living.LightningWraith;
import com.binaris.wizardry.content.entity.living.ShadowWraith;
import com.binaris.wizardry.content.entity.living.StormElemental;
import com.binaris.wizardry.content.entity.projectile.FireBombEntity;
import com.binaris.wizardry.content.spell.necromancy.Banish;
import com.binaris.wizardry.core.mixin.accessor.FallingBlockEntityAccessor;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.Spells;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class ForfeitRegistry {
    private static final Set<Forfeit> FORFEITS = new HashSet<Forfeit>();

    public static void create(String name, SpellTier tier, Element element, BiConsumer<Level, Player> effect) {
        ForfeitRegistry.create(new Forfeit(name, element, tier, effect));
    }

    public static void create(ResourceLocation location, SpellTier tier, Element element, BiConsumer<Level, Player> effect) {
        ForfeitRegistry.create(new Forfeit(location, element, tier, effect));
    }

    public static void create(Forfeit forfeit) {
        FORFEITS.add(forfeit);
    }

    public static Set<Forfeit> getForfeits() {
        return FORFEITS;
    }

    public static Forfeit getRandomForfeit(Random random, SpellTier tier, Element element) {
        List<Forfeit> forfeits = FORFEITS.stream().filter(forfeit -> forfeit.getSpellTier() == tier && forfeit.getElement() == element).toList();
        if (forfeits.isEmpty()) {
            EBLogger.warn("No forfeits with tier {} and element {}!", tier, element);
            return null;
        }
        return forfeits.get(random.nextInt(forfeits.size()));
    }

    public static void register() {
        ForfeitRegistry.create("burn_self", SpellTiers.NOVICE, Elements.FIRE, (Level w, Player p) -> p.m_20254_(5));
        ForfeitRegistry.create("firebomb", SpellTiers.APPRENTICE, Elements.FIRE, (Level w, Player p) -> ForfeitRegistry.summon(w, p.m_20183_(), (Entity)new FireBombEntity((Level)w), 0.0, 5.0, 0.0));
        ForfeitRegistry.create("explode", SpellTiers.ADVANCED, Elements.FIRE, (Level w, Player p) -> w.m_254849_(null, p.m_20185_(), p.m_20186_(), p.m_20189_(), 2.0f, Level.ExplosionInteraction.NONE));
        ForfeitRegistry.create("blazes", SpellTiers.ADVANCED, Elements.FIRE, (Level w, Player p) -> IntStream.range(0, 3).forEach(i -> ForfeitRegistry.summon(w, BlockUtil.findNearbyFloorSpace((Entity)p, 4, 2), (Entity)new Blaze(EntityType.f_20551_, w), 0.5, 0.0, 0.5)));
        ForfeitRegistry.create("burn_surroundings", SpellTiers.MASTER, Elements.FIRE, (Level w, Player p) -> {
            if (w.f_46443_ || !EntityUtil.canDamageBlocks((LivingEntity)p, w)) {
                return;
            }
            BlockUtil.getBlockSphere(p.m_20183_(), 6.0).stream().filter(pos -> w.f_46441_.m_188499_() && w.m_46859_(pos) && BlockUtil.canPlaceBlock((LivingEntity)p, w, pos)).forEach(pos -> w.m_46597_(pos, Blocks.f_50083_.m_49966_()));
        });
        ForfeitRegistry.create("meteors", SpellTiers.MASTER, Elements.FIRE, (Level w, Player p) -> {
            if (!w.f_46443_) {
                for (int i = 0; i < 5; ++i) {
                    w.m_7967_((Entity)new MeteorEntity((Level)w, p.m_20185_() + w.f_46441_.m_188500_() * 16.0 - 8.0, p.m_20186_() + 40.0 + w.f_46441_.m_188500_() * 30.0, p.m_20189_() + w.f_46441_.m_188500_() * 16.0 - 8.0, 1.0f, EntityUtil.canDamageBlocks((LivingEntity)p, w)));
                }
            }
        });
        ForfeitRegistry.create("freeze_self", SpellTiers.NOVICE, Elements.ICE, (Level w, Player p) -> {
            if (!w.f_46443_) {
                p.m_7292_(new MobEffectInstance(EBMobEffects.FROST.get(), 200));
            }
        });
        ForfeitRegistry.create("freeze_self_2", SpellTiers.NOVICE, Elements.ICE, (Level w, Player p) -> {
            if (!w.f_46443_) {
                p.m_7292_(new MobEffectInstance(EBMobEffects.FROST.get(), 300, 1));
            }
        });
        ForfeitRegistry.create("ice_spikes", SpellTiers.APPRENTICE, Elements.ICE, (Level w, Player p) -> {
            if (w.f_46443_) {
                return;
            }
            for (int i = 0; i < 5; ++i) {
                IceSpikeConstruct iceSpike = new IceSpikeConstruct((Level)w);
                double x = p.m_20185_() + 2.0 - (double)(w.f_46441_.m_188501_() * 4.0f);
                double z = p.m_20189_() + 2.0 - (double)(w.f_46441_.m_188501_() * 4.0f);
                Integer y = BlockUtil.getNearestSurface(w, BlockPos.m_274561_((double)x, (double)p.m_20186_(), (double)z), Direction.UP, 2, true, BlockUtil.SurfaceCriteria.basedOn(ForfeitRegistry::isCollisionShapeFullBlock));
                iceSpike.lifetime = 45 + w.f_46441_.m_188503_(15);
                if (y == null) break;
                iceSpike.setFacing(Direction.UP);
                iceSpike.m_6034_(x, y.intValue(), z);
                w.m_7967_((Entity)iceSpike);
            }
        });
        ForfeitRegistry.create("blizzard", SpellTiers.ADVANCED, Elements.ICE, (Level w, Player p) -> ForfeitRegistry.summon(w, p.m_20183_(), new BlizzardConstruct((Level)w), 0.0, 0.0, 0.0));
        ForfeitRegistry.create("ice_wraiths", SpellTiers.ADVANCED, Elements.ICE, (Level w, Player p) -> IntStream.range(0, 3).forEach(i -> ForfeitRegistry.summon(w, BlockUtil.findNearbyFloorSpace((Entity)p, 4, 2), (Entity)new IceWraith((Level)w), 0.0, 0.0, 0.0)));
        ForfeitRegistry.create("hailstorm", SpellTiers.MASTER, Elements.ICE, (Level w, Player p) -> ForfeitRegistry.summon(w, p.m_20183_(), new HailstormConstruct((Level)w), 0.0, 5.0, -3.0));
        ForfeitRegistry.create("ice_giant", SpellTiers.MASTER, Elements.ICE, (Level w, Player p) -> ForfeitRegistry.summon(w, p.m_20183_(), (Entity)new IceGiant((Level)w), p.m_20154_().f_82479_ * 4.0, 0.0, p.m_20154_().f_82481_ * 4.0));
        ForfeitRegistry.create("thunder", SpellTiers.NOVICE, Elements.LIGHTNING, (Level w, Player p) -> ForfeitRegistry.summon(w, BlockUtil.findNearbyFloorSpace((Entity)p, 4, 2), (Entity)new LightningWraith((Level)w), 0.5, 0.0, 0.5));
        ForfeitRegistry.create("storm", SpellTiers.APPRENTICE, Elements.LIGHTNING, (Level w, Player p) -> {
            if (!Spells.INVOKE_WEATHER.isEnabled(SpellContext.WANDS)) {
                return;
            }
            int shortWeatherTime = (100 + new Random().nextInt(200)) * 20;
            if (!w.f_46443_) {
                ((ServerLevel)w).m_8606_(0, shortWeatherTime, true, true);
            }
        });
        ForfeitRegistry.create("lightning_sigils", SpellTiers.APPRENTICE, Elements.LIGHTNING, (Level w, Player p) -> {
            for (Direction direction : BlockUtil.getHorizontals()) {
                BlockPos pos = p.m_20183_().m_5484_(direction, 2);
                Integer y = BlockUtil.getNearestFloor(w, pos, 2);
                if (y == null) continue;
                ForfeitRegistry.summon(w, pos.m_175288_(y.intValue()), new LightningSigilConstruct((Level)w), 0.5, 0.0, 0.5);
            }
        });
        ForfeitRegistry.create("lightning", SpellTiers.ADVANCED, Elements.LIGHTNING, (Level w, Player p) -> ForfeitRegistry.summon(w, p.m_20183_(), (Entity)new LightningBolt(EntityType.f_20465_, w), 0.0, 0.0, 0.0));
        ForfeitRegistry.create("lightning_wraiths", SpellTiers.ADVANCED, Elements.LIGHTNING, (Level w, Player p) -> IntStream.range(0, 3).forEach(i -> ForfeitRegistry.summon(w, BlockUtil.findNearbyFloorSpace((Entity)p, 4, 2), (Entity)new LightningWraith((Level)w), 0.5, 0.0, 0.5)));
        ForfeitRegistry.create("storm_elemental", SpellTiers.MASTER, Elements.LIGHTNING, (Level w, Player p) -> Arrays.stream(BlockUtil.getHorizontals()).forEach(direction -> ForfeitRegistry.summon(w, p.m_20183_().m_5484_(direction, 3), (Entity)new StormElemental((Level)w), 0.5, 0.0, 0.5)));
        ForfeitRegistry.create("nausea", SpellTiers.NOVICE, Elements.NECROMANCY, (Level w, Player p) -> {
            if (!w.f_46443_) {
                p.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 400));
            }
        });
        ForfeitRegistry.create("zombie_horde", SpellTiers.APPRENTICE, Elements.NECROMANCY, (Level w, Player p) -> IntStream.range(0, 3).forEach(i -> ForfeitRegistry.summon(w, BlockUtil.findNearbyFloorSpace((Entity)p, 4, 2), (Entity)new Zombie(EntityType.f_20501_, w), 0.5, 0.0, 0.5)));
        ForfeitRegistry.create("wither_self", SpellTiers.ADVANCED, Elements.NECROMANCY, (Level w, Player p) -> {
            if (!w.f_46443_) {
                p.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 400));
            }
        });
        ForfeitRegistry.create("cripple_self", SpellTiers.ADVANCED, Elements.NECROMANCY, (Level w, Player p) -> {
            if (!w.f_46443_) {
                p.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 400, 2));
            }
        });
        ForfeitRegistry.create("shadow_wraiths", SpellTiers.MASTER, Elements.NECROMANCY, (Level w, Player p) -> IntStream.range(0, 3).forEach(i -> ForfeitRegistry.summon(w, BlockUtil.findNearbyFloorSpace((Entity)p, 4, 2), (Entity)new ShadowWraith((Level)w), 0.5, 0.0, 0.5)));
        ForfeitRegistry.create("squid", SpellTiers.NOVICE, Elements.EARTH, (Level w, Player p) -> ForfeitRegistry.summon(w, p.m_20183_(), (Entity)new Squid(EntityType.f_20480_, w), 0.0, 3.0, 0.0));
        ForfeitRegistry.create("uproot_plants", SpellTiers.APPRENTICE, Elements.EARTH, (Level w, Player p) -> {
            if (w.m_5776_()) {
                return;
            }
            List<BlockPos> sphere = BlockUtil.getBlockSphere(p.m_20183_(), 5.0);
            sphere.removeIf(pos -> !BlockUtil.canBreak(p, w, pos, false));
            sphere.forEach(pos -> w.m_46961_(pos, true));
        });
        ForfeitRegistry.create("poison_self", SpellTiers.APPRENTICE, Elements.EARTH, (Level w, Player p) -> {
            if (!w.f_46443_) {
                p.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 400, 1));
            }
        });
        ForfeitRegistry.create("flood", SpellTiers.ADVANCED, Elements.EARTH, (Level w, Player p) -> {
            if (w.m_5776_()) {
                return;
            }
            List<BlockPos> sphere = BlockUtil.getBlockSphere(p.m_20183_().m_7494_(), 2.0);
            sphere.removeIf(pos -> !BlockUtil.canBlockBeReplaced(w, pos, true) || !BlockUtil.canPlaceBlock((LivingEntity)p, w, pos));
            sphere.forEach(pos -> w.m_46597_(pos, Blocks.f_49990_.m_49966_()));
        });
        ForfeitRegistry.create("bury_self", SpellTiers.MASTER, Elements.EARTH, (Level w, Player p) -> {
            if (w.f_46443_) {
                return;
            }
            List<BlockPos> sphere = BlockUtil.getBlockSphere(p.m_20183_(), 4.0);
            sphere.forEach(pos -> {
                FallingBlockEntity blockEntity = FallingBlockEntityAccessor.createFallingBlockEntity(w, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, Blocks.f_50493_.m_49966_());
                blockEntity.m_20334_(blockEntity.m_20184_().f_82479_, 0.3 * (double)(4 - (p.m_20183_().m_123342_() - pos.m_123342_())), blockEntity.m_20184_().f_82481_);
                w.m_7967_((Entity)blockEntity);
            });
        });
        ForfeitRegistry.create("spill_inventory", SpellTiers.NOVICE, Elements.SORCERY, (Level w, Player p) -> {
            for (int i = 0; i < p.m_150109_().f_35974_.size(); ++i) {
                ItemStack stack = (ItemStack)p.m_150109_().f_35974_.get(i);
                if (stack.m_41619_()) continue;
                p.m_7197_(stack, true, false);
                p.m_150109_().f_35974_.set(i, (Object)ItemStack.f_41583_);
            }
        });
        ForfeitRegistry.create("teleport_self", SpellTiers.APPRENTICE, Elements.SORCERY, (Level w, Player p) -> ((Banish)Spells.BANISH).teleport((LivingEntity)p, (Level)w, 8.0 + w.f_46441_.m_188500_() * 8.0));
        ForfeitRegistry.create("levitate_self", SpellTiers.ADVANCED, Elements.SORCERY, (Level w, Player p) -> {
            if (!w.f_46443_) {
                p.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 200));
            }
        });
        ForfeitRegistry.create("vex_horde", SpellTiers.ADVANCED, Elements.SORCERY, (Level w, Player p) -> IntStream.range(0, 4).forEach(i -> ForfeitRegistry.summon(w, BlockUtil.findNearbyFloorSpace((Entity)p, 4, 2), (Entity)new Vex(EntityType.f_20491_, w), 0.5, 1.0, 0.5)));
        ForfeitRegistry.create("arrow_rain", SpellTiers.MASTER, Elements.SORCERY, (Level w, Player p) -> ForfeitRegistry.summon(w, p.m_20183_(), new ArrowRainConstruct((Level)w), 0.0, 5.0, -3.0));
        ForfeitRegistry.create("damage_self", SpellTiers.NOVICE, Elements.HEALING, (Level w, Player p) -> p.m_6469_(p.m_269291_().m_269425_(), 4.0f));
        ForfeitRegistry.create("spill_armour", SpellTiers.NOVICE, Elements.HEALING, (Level w, Player p) -> IntStream.range(0, p.m_150109_().f_35975_.size()).forEach(i -> {
            ItemStack stack = (ItemStack)p.m_150109_().f_35975_.get(i);
            if (!stack.m_41619_()) {
                p.m_7197_(stack, true, false);
                p.m_150109_().f_35975_.set(i, (Object)ItemStack.f_41583_);
            }
        }));
        ForfeitRegistry.create("hunger", SpellTiers.APPRENTICE, Elements.HEALING, (Level w, Player p) -> {
            if (!w.f_46443_) {
                p.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 400, 4));
            }
        });
        ForfeitRegistry.create("blind_self", SpellTiers.APPRENTICE, Elements.HEALING, (Level w, Player p) -> {
            if (!w.f_46443_) {
                p.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 200));
            }
        });
        ForfeitRegistry.create("weaken_self", SpellTiers.ADVANCED, Elements.HEALING, (Level w, Player p) -> {
            if (!w.f_46443_) {
                p.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 600, 3));
            }
        });
        ForfeitRegistry.create("jam_self", SpellTiers.ADVANCED, Elements.HEALING, (Level w, Player p) -> {
            if (!w.f_46443_) {
                p.m_7292_(new MobEffectInstance(EBMobEffects.ARCANE_JAMMER.get(), 300));
            }
        });
        ForfeitRegistry.create("curse_self", SpellTiers.MASTER, Elements.HEALING, (Level w, Player p) -> {
            if (!w.f_46443_) {
                p.m_7292_(new MobEffectInstance(EBMobEffects.CURSE_OF_UNDEATH.get(), Integer.MAX_VALUE));
            }
        });
    }

    public static boolean isCollisionShapeFullBlock(BlockGetter blockGetter, BlockPos pos) {
        return blockGetter.m_8055_(pos).m_60838_(blockGetter, pos);
    }

    public static void summon(Level world, @Nullable BlockPos pos, Entity entity, double xOffset, double yOffset, double zOffset) {
        if (world.f_46443_) {
            return;
        }
        if (pos == null) {
            return;
        }
        entity.m_6034_((double)pos.m_123341_() + xOffset, (double)pos.m_123342_() + yOffset, (double)pos.m_123343_() + zOffset);
        world.m_7967_(entity);
    }
}

